# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from swagger_server.models.base_model_ import Model
from swagger_server.models.topology_port import TopologyPort  # noqa: F401,E501
from swagger_server import util


class TopologyNode(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, node_id: str=None, port: List[TopologyPort]=None):  # noqa: E501
        """TopologyNode - a model defined in Swagger

        :param node_id: The node_id of this TopologyNode.  # noqa: E501
        :type node_id: str
        :param port: The port of this TopologyNode.  # noqa: E501
        :type port: List[TopologyPort]
        """
        self.swagger_types = {
            'node_id': str,
            'port': List[TopologyPort]
        }

        self.attribute_map = {
            'node_id': 'node-id',
            'port': 'port'
        }
        self._node_id = node_id
        self._port = port

    @classmethod
    def from_dict(cls, dikt) -> 'TopologyNode':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The topology.Node of this TopologyNode.  # noqa: E501
        :rtype: TopologyNode
        """
        return util.deserialize_model(dikt, cls)

    @property
    def node_id(self) -> str:
        """Gets the node_id of this TopologyNode.


        :return: The node_id of this TopologyNode.
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id: str):
        """Sets the node_id of this TopologyNode.


        :param node_id: The node_id of this TopologyNode.
        :type node_id: str
        """

        self._node_id = node_id

    @property
    def port(self) -> List[TopologyPort]:
        """Gets the port of this TopologyNode.


        :return: The port of this TopologyNode.
        :rtype: List[TopologyPort]
        """
        return self._port

    @port.setter
    def port(self, port: List[TopologyPort]):
        """Sets the port of this TopologyNode.


        :param port: The port of this TopologyNode.
        :type port: List[TopologyPort]
        """

        self._port = port
