/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.DecorInterfaceProvider;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.posimo.PathDrawer;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.posimo.RacorderOrthogonal;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathDrawerInterface
implements PathDrawer {
    private final Rose rose;
    private final ISkinParam param;
    private final LinkType linkType;

    public static PathDrawerInterface create(ISkinParam iSkinParam, LinkType linkType) {
        return new PathDrawerInterface(new Rose(), iSkinParam, linkType);
    }

    private PathDrawerInterface(Rose rose, ISkinParam iSkinParam, LinkType linkType) {
        this.rose = rose;
        this.param = iSkinParam;
        this.linkType = linkType;
    }

    @Override
    public void drawPathBefore(UGraphic uGraphic, Positionable positionable, Positionable positionable2, Path path) {
    }

    private void noDash(UGraphic uGraphic) {
        throw new UnsupportedOperationException();
    }

    private void goDash(UGraphic uGraphic) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawPathAfter(UGraphic uGraphic, Positionable positionable, Positionable positionable2, Path path) {
        Object object;
        DotPath dotPath = path.getDotPath();
        RacorderOrthogonal racorderOrthogonal = new RacorderOrthogonal();
        Point2D point2D = dotPath.getEndPoint();
        DotPath dotPath2 = racorderOrthogonal.getRacordIn(PositionableUtils.convert(positionable2), dotPath.getEndTangeante());
        Point2D point2D2 = dotPath2.getEndPoint();
        double d = this.atan2(point2D, point2D2);
        Point2D point2D3 = this.drawSymbol(uGraphic, d, point2D2, this.linkType.getDecor1());
        Point2D point2D4 = dotPath.getStartPoint();
        DotPath dotPath3 = racorderOrthogonal.getRacordOut(PositionableUtils.convert(positionable), dotPath.getStartTangeante());
        Point2D point2D5 = dotPath3.getStartPoint();
        double d2 = this.atan2(point2D4, point2D5);
        Point2D point2D6 = this.drawSymbol(uGraphic, d2, point2D5, this.linkType.getDecor2());
        if (point2D3 != null) {
            object = this.getLine(point2D, point2D3);
            dotPath = dotPath.addAfter((CubicCurve2D.Double)object);
        }
        if (point2D6 != null) {
            object = this.getLine(point2D6, point2D4);
            dotPath = dotPath.addBefore((CubicCurve2D.Double)object);
        }
        if ((object = this.linkType.getStyle()) == LinkStyle.__toremove_INTERFACE_PROVIDER || object == LinkStyle.__toremove_INTERFACE_USER) {
            DecorInterfaceProvider decorInterfaceProvider = new DecorInterfaceProvider((LinkStyle)((Object)object));
            Map<Point2D, Double> map = dotPath.somePoints();
            Point2D point2D7 = PathDrawerInterface.getFarest(point2D5, point2D2, map.keySet());
            uGraphic = uGraphic.apply(new UChangeBackColor(this.rose.getHtmlColor(this.param, ColorParam.background)));
            uGraphic = uGraphic.apply(new UChangeColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder)));
            decorInterfaceProvider.drawDecor(uGraphic, point2D7, map.get(point2D7));
        }
        uGraphic = uGraphic.apply(new UChangeColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder)));
        if (this.linkType.isDashed()) {
            this.goDash(uGraphic);
        }
        uGraphic.draw(dotPath);
        if (this.linkType.isDashed()) {
            this.noDash(uGraphic);
        }
    }

    private double atan2(Point2D point2D, Point2D point2D2) {
        double d = -point2D.getX() + point2D2.getX();
        double d2 = point2D.getY() - point2D2.getY();
        double d3 = Math.atan2(d, d2);
        return d3;
    }

    private Point2D drawSymbol(UGraphic uGraphic, double d, Point2D point2D, LinkDecor linkDecor) {
        throw new UnsupportedOperationException();
    }

    private CubicCurve2D.Double getLine(Point2D point2D, Point2D point2D2) {
        return new CubicCurve2D.Double(point2D.getX(), point2D.getY(), point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D2.getX(), point2D2.getY());
    }

    private static Point2D getFarest(Point2D point2D, Point2D point2D2, Collection<Point2D> collection) {
        Point2D point2D3 = null;
        double d = 0.0;
        for (Point2D point2D4 : collection) {
            if (point2D3 == null) {
                point2D3 = point2D4;
                d = point2D.distanceSq(point2D3) + point2D2.distanceSq(point2D3);
                continue;
            }
            double d2 = point2D.distanceSq(point2D4) + point2D2.distanceSq(point2D4);
            if (!(d2 < d)) continue;
            point2D3 = point2D4;
            d = d2;
        }
        if (point2D3 == null) {
            throw new IllegalArgumentException();
        }
        return point2D3;
    }

    private Point2D drawSquare(UGraphic uGraphic, double d, double d2) {
        uGraphic = uGraphic.apply(new UChangeBackColor(this.rose.getHtmlColor(this.param, ColorParam.classBackground)));
        uGraphic = uGraphic.apply(new UChangeColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder)));
        uGraphic.apply(new UTranslate(d - 5.0, d2 - 5.0)).draw(new URectangle(10.0, 10.0));
        return new Point2D.Double(d, d2);
    }

    Point2D drawExtends(UGraphic uGraphic, double d, double d2, double d3) {
        uGraphic = uGraphic.apply(new UChangeBackColor(this.rose.getHtmlColor(this.param, ColorParam.background)));
        uGraphic = uGraphic.apply(new UChangeColor(this.rose.getHtmlColor(this.param, ColorParam.classBorder)));
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 1.0);
        uPolygon.addPoint(-9.0, 26.0);
        uPolygon.addPoint(9.0, 26.0);
        uPolygon.rotate(d3);
        uGraphic.apply(new UTranslate(d, d2)).draw(uPolygon);
        Point2D point2D = BezierUtils.middle(uPolygon.getPoints().get(1), uPolygon.getPoints().get(2));
        point2D.setLocation(point2D.getX() + d, point2D.getY() + d2);
        return point2D;
    }

    private Point2D drawDiamond(UGraphic uGraphic, double d, double d2, double d3) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(-5.0, 7.0);
        uPolygon.addPoint(0.0, 14.0);
        uPolygon.addPoint(5.0, 7.0);
        uPolygon.rotate(d3);
        uGraphic.apply(new UTranslate(d, d2)).draw(uPolygon);
        Point2D point2D = uPolygon.getPoints().get(2);
        point2D.setLocation(point2D.getX() + d, point2D.getY() + d2);
        return point2D;
    }

    private Point2D drawArrow(UGraphic uGraphic, double d, double d2, double d3) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(-6.0, 10.0);
        uPolygon.addPoint(0.0, 4.0);
        uPolygon.addPoint(6.0, 10.0);
        uPolygon.rotate(d3);
        uGraphic.apply(new UTranslate(d, d2)).draw(uPolygon);
        Point2D point2D = uPolygon.getPoints().get(2);
        point2D.setLocation(point2D.getX() + d, point2D.getY() + d2);
        return point2D;
    }

    private Point2D nullIfContained(Point2D point2D, Positionable positionable, Positionable positionable2) {
        if (PositionableUtils.contains(positionable, point2D)) {
            return null;
        }
        if (PositionableUtils.contains(positionable2, point2D)) {
            return null;
        }
        return point2D;
    }
}

