# Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import os
from common.Constants import DEFAULT_CONTEXT_NAME
from common.proto.context_pb2 import ContextId, DeviceOperationalStatusEnum
from common.tools.object_factory.Context import json_context_id

# Context info
CONTEXT_NAME_P4 = DEFAULT_CONTEXT_NAME
ADMIN_CONTEXT_ID = ContextId(**json_context_id(CONTEXT_NAME_P4))

# Device and rule cardinality variables
DEV_NB = 3
CONNECTION_RULES = 3
ENDPOINT_RULES = 2
DATAPLANE_RULES_NB_INT_B1 = 5
DATAPLANE_RULES_NB_INT_B2 = 6
DATAPLANE_RULES_NB_INT_B3 = 8
DATAPLANE_RULES_NB_RT_EDGE = 7
DATAPLANE_RULES_NB_RT_CORP = 7
DATAPLANE_RULES_NB_ACL = 1
DATAPLANE_RULES_NB_TOT = \
    DATAPLANE_RULES_NB_INT_B1 +\
    DATAPLANE_RULES_NB_INT_B2 +\
    DATAPLANE_RULES_NB_INT_B3 +\
    DATAPLANE_RULES_NB_RT_EDGE +\
    DATAPLANE_RULES_NB_RT_CORP +\
    DATAPLANE_RULES_NB_ACL

# Topology descriptor
DESC_TOPO = os.path.join(
    os.path.dirname(
        os.path.abspath(__file__)
    ),
    'descriptors', 'topology.json'
)

# Rule insertion descriptors
# The switch cannot digest all rules at once, hence we insert in batches
DESC_FILE_RULES_INSERT_INT_B1 = os.path.join(
    os.path.dirname(
        os.path.abspath(__file__)
    ),
    'descriptors', 'rules-insert-int-b1.json'
)
DESC_FILE_RULES_INSERT_INT_B2 = os.path.join(
    os.path.dirname(
        os.path.abspath(__file__)
    ),
    'descriptors', 'rules-insert-int-b2.json'
)
DESC_FILE_RULES_INSERT_INT_B3 = os.path.join(
    os.path.dirname(
        os.path.abspath(__file__)
    ),
    'descriptors', 'rules-insert-int-b3.json'
)
DESC_FILE_RULES_INSERT_ROUTING_EDGE = os.path.join(
    os.path.dirname(
        os.path.abspath(__file__)
    ),
    'descriptors', 'rules-insert-routing-edge.json'
)
DESC_FILE_RULES_INSERT_ROUTING_CORP = os.path.join(
    os.path.dirname(
        os.path.abspath(__file__)
    ),
    'descriptors', 'rules-insert-routing-corp.json'
)
DESC_FILE_RULES_INSERT_ACL = os.path.join(
    os.path.dirname(
        os.path.abspath(__file__)
    ),
    'descriptors', 'rules-insert-acl.json'
)

# Rule deletion descriptor
DESC_FILE_RULES_DELETE_ALL = os.path.join(
    os.path.dirname(
        os.path.abspath(__file__)
    ),
    'descriptors', 'rules-remove.json'
)

def verify_number_of_rules(devices, desired_rules_nb):
    # Iterate all devices
    for device in devices:
        # Skip non-P4 devices
        if device.device_type != "p4-switch": continue

        # We want the device to be active
        assert \
            device.device_operational_status == DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_ENABLED

        # Get the configuration rules of this device
        config_rules = device.device_config.config_rules

        # Expected rule cardinality
        assert len(config_rules) == desired_rules_nb
