# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import tunnel
class tunnels(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices/connectivity-matrix/underlay/tunnels. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Underlay TE tunnels supporting this TE link.
  """
  __slots__ = ('_path_helper', '_extmethods', '__sharing','__tunnel',)

  _yang_name = 'tunnels'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sharing = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="sharing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)
    self.__tunnel = YANGDynClass(base=YANGListType("tunnel_name",tunnel.tunnel, yang_name="tunnel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tunnel-name', extensions=None), is_container='list', yang_name="tunnel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices', 'connectivity-matrix', 'underlay', 'tunnels']

  def _get_sharing(self):
    """
    Getter method for sharing, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/underlay/tunnels/sharing (boolean)

    YANG Description: 'true' if the underlay tunnel can be shared with other
TE links;
'false' if the underlay tunnel is dedicated to this
TE link.
This leaf is the default option for all TE tunnels
and may be overridden by the per-TE-tunnel value.
    """
    return self.__sharing
      
  def _set_sharing(self, v, load=False):
    """
    Setter method for sharing, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/underlay/tunnels/sharing (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sharing is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sharing() directly.

    YANG Description: 'true' if the underlay tunnel can be shared with other
TE links;
'false' if the underlay tunnel is dedicated to this
TE link.
This leaf is the default option for all TE tunnels
and may be overridden by the per-TE-tunnel value.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="sharing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sharing must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="sharing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)""",
        })

    self.__sharing = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sharing(self):
    self.__sharing = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="sharing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='boolean', is_config=False)


  def _get_tunnel(self):
    """
    Getter method for tunnel, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/underlay/tunnels/tunnel (list)

    YANG Description: Zero, one, or more underlay TE tunnels that support this
TE link.
    """
    return self.__tunnel
      
  def _set_tunnel(self, v, load=False):
    """
    Setter method for tunnel, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/underlay/tunnels/tunnel (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tunnel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tunnel() directly.

    YANG Description: Zero, one, or more underlay TE tunnels that support this
TE link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("tunnel_name",tunnel.tunnel, yang_name="tunnel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tunnel-name', extensions=None), is_container='list', yang_name="tunnel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tunnel must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("tunnel_name",tunnel.tunnel, yang_name="tunnel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tunnel-name', extensions=None), is_container='list', yang_name="tunnel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)""",
        })

    self.__tunnel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tunnel(self):
    self.__tunnel = YANGDynClass(base=YANGListType("tunnel_name",tunnel.tunnel, yang_name="tunnel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tunnel-name', extensions=None), is_container='list', yang_name="tunnel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

  sharing = __builtin__.property(_get_sharing)
  tunnel = __builtin__.property(_get_tunnel)


  _pyangbind_elements = OrderedDict([('sharing', sharing), ('tunnel', tunnel), ])


