# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import network_types
from . import supporting_network
from . import node
from . import link
from . import te_topology_identifier
from . import te
class network(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Describes a network.
A network typically contains an inventory of nodes,
topological information (augmented through the
network-topology data model), and layering information.
  """
  __slots__ = ('_path_helper', '_extmethods', '__network_id','__network_types','__supporting_network','__node','__link','__te_topology_identifier','__te',)

  _yang_name = 'network'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__network_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='network-id', is_config=True)
    self.__network_types = YANGDynClass(base=network_types.network_types, is_container='container', yang_name="network-types", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='container', is_config=True)
    self.__supporting_network = YANGDynClass(base=YANGListType("network_ref",supporting_network.supporting_network, yang_name="supporting-network", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref', extensions=None), is_container='list', yang_name="supporting-network", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)
    self.__node = YANGDynClass(base=YANGListType("node_id",node.node, yang_name="node", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='node-id', extensions=None), is_container='list', yang_name="node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)
    self.__link = YANGDynClass(base=YANGListType("link_id",link.link, yang_name="link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='link-id', extensions=None), is_container='list', yang_name="link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)
    self.__te_topology_identifier = YANGDynClass(base=te_topology_identifier.te_topology_identifier, is_container='container', yang_name="te-topology-identifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network']

  def _get_network_id(self):
    """
    Getter method for network_id, mapped from YANG variable /networks/network/network_id (network-id)

    YANG Description: Identifies a network.
    """
    return self.__network_id
      
  def _set_network_id(self, v, load=False):
    """
    Setter method for network_id, mapped from YANG variable /networks/network/network_id (network-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_network_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_network_id() directly.

    YANG Description: Identifies a network.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="network-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='network-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """network_id must be of a type compatible with network-id""",
          'defined-type': "ietf-network:network-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='network-id', is_config=True)""",
        })

    self.__network_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_network_id(self):
    self.__network_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="network-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='network-id', is_config=True)


  def _get_network_types(self):
    """
    Getter method for network_types, mapped from YANG variable /networks/network/network_types (container)

    YANG Description: Serves as an augmentation target.
The network type is indicated through corresponding
presence containers augmented into this container.
    """
    return self.__network_types
      
  def _set_network_types(self, v, load=False):
    """
    Setter method for network_types, mapped from YANG variable /networks/network/network_types (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_network_types is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_network_types() directly.

    YANG Description: Serves as an augmentation target.
The network type is indicated through corresponding
presence containers augmented into this container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=network_types.network_types, is_container='container', yang_name="network-types", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """network_types must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=network_types.network_types, is_container='container', yang_name="network-types", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='container', is_config=True)""",
        })

    self.__network_types = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_network_types(self):
    self.__network_types = YANGDynClass(base=network_types.network_types, is_container='container', yang_name="network-types", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='container', is_config=True)


  def _get_supporting_network(self):
    """
    Getter method for supporting_network, mapped from YANG variable /networks/network/supporting_network (list)

    YANG Description: An underlay network, used to represent layered network
topologies.
    """
    return self.__supporting_network
      
  def _set_supporting_network(self, v, load=False):
    """
    Setter method for supporting_network, mapped from YANG variable /networks/network/supporting_network (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supporting_network is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supporting_network() directly.

    YANG Description: An underlay network, used to represent layered network
topologies.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("network_ref",supporting_network.supporting_network, yang_name="supporting-network", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref', extensions=None), is_container='list', yang_name="supporting-network", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supporting_network must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("network_ref",supporting_network.supporting_network, yang_name="supporting-network", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref', extensions=None), is_container='list', yang_name="supporting-network", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)""",
        })

    self.__supporting_network = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supporting_network(self):
    self.__supporting_network = YANGDynClass(base=YANGListType("network_ref",supporting_network.supporting_network, yang_name="supporting-network", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref', extensions=None), is_container='list', yang_name="supporting-network", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)


  def _get_node(self):
    """
    Getter method for node, mapped from YANG variable /networks/network/node (list)

    YANG Description: The inventory of nodes of this network.
    """
    return self.__node
      
  def _set_node(self, v, load=False):
    """
    Setter method for node, mapped from YANG variable /networks/network/node (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_node is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_node() directly.

    YANG Description: The inventory of nodes of this network.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("node_id",node.node, yang_name="node", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='node-id', extensions=None), is_container='list', yang_name="node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """node must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("node_id",node.node, yang_name="node", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='node-id', extensions=None), is_container='list', yang_name="node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)""",
        })

    self.__node = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_node(self):
    self.__node = YANGDynClass(base=YANGListType("node_id",node.node, yang_name="node", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='node-id', extensions=None), is_container='list', yang_name="node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)


  def _get_link(self):
    """
    Getter method for link, mapped from YANG variable /networks/network/link (list)

    YANG Description: A network link connects a local (source) node and
a remote (destination) node via a set of the respective
node's termination points.  It is possible to have several
links between the same source and destination nodes.
Likewise, a link could potentially be re-homed between
termination points.  Therefore, in order to ensure that we
would always know to distinguish between links, every link
is identified by a dedicated link identifier.  Note that a
link models a point-to-point link, not a multipoint link.
    """
    return self.__link
      
  def _set_link(self, v, load=False):
    """
    Setter method for link, mapped from YANG variable /networks/network/link (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link() directly.

    YANG Description: A network link connects a local (source) node and
a remote (destination) node via a set of the respective
node's termination points.  It is possible to have several
links between the same source and destination nodes.
Likewise, a link could potentially be re-homed between
termination points.  Therefore, in order to ensure that we
would always know to distinguish between links, every link
is identified by a dedicated link identifier.  Note that a
link models a point-to-point link, not a multipoint link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("link_id",link.link, yang_name="link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='link-id', extensions=None), is_container='list', yang_name="link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("link_id",link.link, yang_name="link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='link-id', extensions=None), is_container='list', yang_name="link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)""",
        })

    self.__link = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link(self):
    self.__link = YANGDynClass(base=YANGListType("link_id",link.link, yang_name="link", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='link-id', extensions=None), is_container='list', yang_name="link", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)


  def _get_te_topology_identifier(self):
    """
    Getter method for te_topology_identifier, mapped from YANG variable /networks/network/te_topology_identifier (container)

    YANG Description: TE topology identifier container.
    """
    return self.__te_topology_identifier
      
  def _set_te_topology_identifier(self, v, load=False):
    """
    Setter method for te_topology_identifier, mapped from YANG variable /networks/network/te_topology_identifier (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_topology_identifier is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_topology_identifier() directly.

    YANG Description: TE topology identifier container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te_topology_identifier.te_topology_identifier, is_container='container', yang_name="te-topology-identifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_topology_identifier must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te_topology_identifier.te_topology_identifier, is_container='container', yang_name="te-topology-identifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te_topology_identifier = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_topology_identifier(self):
    self.__te_topology_identifier = YANGDynClass(base=te_topology_identifier.te_topology_identifier, is_container='container', yang_name="te-topology-identifier", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_te(self):
    """
    Getter method for te, mapped from YANG variable /networks/network/te (container)

    YANG Description: Indicates TE support.
    """
    return self.__te
      
  def _set_te(self, v, load=False):
    """
    Setter method for te, mapped from YANG variable /networks/network/te (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te() directly.

    YANG Description: Indicates TE support.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te(self):
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  network_id = __builtin__.property(_get_network_id, _set_network_id)
  network_types = __builtin__.property(_get_network_types, _set_network_types)
  supporting_network = __builtin__.property(_get_supporting_network, _set_supporting_network)
  node = __builtin__.property(_get_node, _set_node)
  link = __builtin__.property(_get_link, _set_link)
  te_topology_identifier = __builtin__.property(_get_te_topology_identifier, _set_te_topology_identifier)
  te = __builtin__.property(_get_te, _set_te)


  _pyangbind_elements = OrderedDict([('network_id', network_id), ('network_types', network_types), ('supporting_network', supporting_network), ('node', node), ('link', link), ('te_topology_identifier', te_topology_identifier), ('te', te), ])


