# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import  json,logging
from sqlalchemy import Column, String ,Integer
from sqlalchemy.dialects.postgresql import ARRAY


from ._Base import _Base




class OpticalConfigModel (_Base):
    __tablename__="OpticalConfig"
    opticalconfig_uuid = Column(String, primary_key=True)
    channels=Column(ARRAY(String),nullable=True)
    transcievers= Column(ARRAY(String),nullable=True)
    interfaces =Column(String,nullable=True)
    channel_namespace=Column(String,nullable=True)
    endpoints=Column(ARRAY(String),nullable=True)
    frequency=Column(Integer,nullable=True)
    operational_mode=Column(Integer,nullable=True)
    output_power=Column(String,nullable=True)
    

    
    def dump (self):
       
        return {
            "channels":[{'name':{'index':channel}} for channel in self.channels],
            "transceivers":{"transceiver":[transciever for transciever in self.transcievers]},
            "interfaces":{"interface":json.loads(self.interfaces)},
            "channel_namespace":self.channel_namespace,
            "endpoints":[json.loads(endpoint) for endpoint in self.endpoints],
            "frequency":self.frequency,
            "output_power":self.output_power,
            "operational_mode":self.operational_mode
        }

