from typing import Dict
import grpc, logging
from prometheus_client import Counter, Histogram
from common.database.api.Database import Database
from common.exceptions.ServiceException import ServiceException
from centralizedattackdetector.proto.context_pb2 import Empty
from centralizedattackdetector.proto.service_pb2 import Service
from centralizedattackdetector.proto.monitoring_pb2 import KpiList
from centralizedattackdetector.proto.centralized_attack_detector_pb2_grpc import CentralizedAttackDetectorServiceServicer

LOGGER = logging.getLogger(__name__)


class CentralizedAttackDetectorServiceServicerImpl(CentralizedAttackDetectorServiceServicer):

    def __init__(self, database : Database):
        LOGGER.debug('Creating Servicer...')
        self.database = database
        LOGGER.debug('Servicer Created')

    def NotifyServiceUpdate(self, request : Empty, grpc_context : grpc.ServicerContext) -> Empty:
        LOGGER.debug('NotifyServiceUpdate request: {}'.format(str(request)))
        reply = Empty()
        LOGGER.debug('NotifyServiceUpdate reply: {}'.format(str(reply)))
        return reply
    
    def DetectAttack(self, request : Empty, grpc_context : grpc.ServicerContext) -> Empty:
        LOGGER.debug('DetectAttack request: {}'.format(str(request)))
        reply = Empty()
        LOGGER.debug('DetectAttack reply: {}'.format(str(reply)))
        return reply
    
    def ReportSummarizedKpi(self, request : KpiList, grpc_context : grpc.ServicerContext) -> Empty:
        LOGGER.debug('ReportSummarizedKpi request: {}'.format(str(request)))
        reply = Empty()
        LOGGER.debug('ReportSummarizedKpi reply: {}'.format(str(reply)))
        return reply
    
    def ReportKpi(self, request : KpiList, grpc_context : grpc.ServicerContext) -> Empty:
        LOGGER.debug('ReportKpi request: {}'.format(str(request)))
        reply = Empty()
        LOGGER.debug('ReportKpi reply: {}'.format(str(reply)))
        return reply
