# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import grpc, logging
from typing import Optional
from common.Constants import DEFAULT_CONTEXT_UUID
from common.proto.context_pb2 import Slice, SliceId
from context.client.ContextClient import ContextClient

LOGGER = logging.getLogger(__name__)

def get_slice(
        context_client : ContextClient, slice_uuid : str, context_uuid : str = DEFAULT_CONTEXT_UUID,
        rw_copy : bool = False
    ) -> Optional[Slice]:
    try:
        # pylint: disable=no-member
        slice_id = SliceId()
        slice_id.context_id.context_uuid.uuid = context_uuid
        slice_id.slice_uuid.uuid = slice_uuid
        ro_slice = context_client.GetSlice(slice_id)
        if not rw_copy: return ro_slice
        rw_slice = Slice()
        rw_slice.CopyFrom(ro_slice)
        return rw_slice
    except grpc.RpcError:
        #LOGGER.exception('Unable to get slice({:s} / {:s})'.format(str(context_uuid), str(slice_uuid)))
        return None
