# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import otn
class te_label(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/te-node-attributes/connectivity-matrices/optimizations/optimization-metric/explicit-route-include-objects/route-object-include-object/label-hop/te-label. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container that specifies the TE label.  The choices can
be augmented for specific data-plane technologies.
  """
  __slots__ = ('_path_helper', '_extmethods', '__generic','__otn','__vlanid','__direction',)

  _yang_name = 'te-label'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__generic = YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='rt-types:generalized-label', is_config=True)
    self.__otn = YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)
    self.__vlanid = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlanid", parent=self, choice=('technology', 'eth'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vlanid', is_config=True)
    self.__direction = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'forward': {}, 'reverse': {}},), default=six.text_type("forward"), is_leaf=True, yang_name="direction", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-label-direction', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'te-node-attributes', 'connectivity-matrices', 'optimizations', 'optimization-metric', 'explicit-route-include-objects', 'route-object-include-object', 'label-hop', 'te-label']

  def _get_generic(self):
    """
    Getter method for generic, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/optimizations/optimization_metric/explicit_route_include_objects/route_object_include_object/label_hop/te_label/generic (rt-types:generalized-label)

    YANG Description: TE label specified in a generic format.
    """
    return self.__generic
      
  def _set_generic(self, v, load=False):
    """
    Setter method for generic, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/optimizations/optimization_metric/explicit_route_include_objects/route_object_include_object/label_hop/te_label/generic (rt-types:generalized-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_generic is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_generic() directly.

    YANG Description: TE label specified in a generic format.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBinary, is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='rt-types:generalized-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """generic must be of a type compatible with rt-types:generalized-label""",
          'defined-type': "rt-types:generalized-label",
          'generated-type': """YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='rt-types:generalized-label', is_config=True)""",
        })

    self.__generic = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_generic(self):
    self.__generic = YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="generic", parent=self, choice=('technology', 'generic'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='rt-types:generalized-label', is_config=True)


  def _get_otn(self):
    """
    Getter method for otn, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/optimizations/optimization_metric/explicit_route_include_objects/route_object_include_object/label_hop/te_label/otn (container)

    YANG Description: Label hop for OTN.
    """
    return self.__otn
      
  def _set_otn(self, v, load=False):
    """
    Setter method for otn, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/optimizations/optimization_metric/explicit_route_include_objects/route_object_include_object/label_hop/te_label/otn (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_otn is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_otn() directly.

    YANG Description: Label hop for OTN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=otn.otn, is_container='container', yang_name="otn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """otn must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)""",
        })

    self.__otn = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_otn(self):
    self.__otn = YANGDynClass(base=otn.otn, is_container='container', yang_name="otn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='container', is_config=True)


  def _get_vlanid(self):
    """
    Getter method for vlanid, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/optimizations/optimization_metric/explicit_route_include_objects/route_object_include_object/label_hop/te_label/vlanid (etht-types:vlanid)

    YANG Description: VLAN tag id.
    """
    return self.__vlanid
      
  def _set_vlanid(self, v, load=False):
    """
    Setter method for vlanid, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/optimizations/optimization_metric/explicit_route_include_objects/route_object_include_object/label_hop/te_label/vlanid (etht-types:vlanid)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlanid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlanid() directly.

    YANG Description: VLAN tag id.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlanid", parent=self, choice=('technology', 'eth'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vlanid', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlanid must be of a type compatible with etht-types:vlanid""",
          'defined-type': "etht-types:vlanid",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlanid", parent=self, choice=('technology', 'eth'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vlanid', is_config=True)""",
        })

    self.__vlanid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlanid(self):
    self.__vlanid = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlanid", parent=self, choice=('technology', 'eth'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-eth-te-topology', defining_module='ietf-eth-te-topology', yang_type='etht-types:vlanid', is_config=True)


  def _get_direction(self):
    """
    Getter method for direction, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/optimizations/optimization_metric/explicit_route_include_objects/route_object_include_object/label_hop/te_label/direction (te-label-direction)

    YANG Description: Label direction.
    """
    return self.__direction
      
  def _set_direction(self, v, load=False):
    """
    Setter method for direction, mapped from YANG variable /networks/network/node/te/te_node_attributes/connectivity_matrices/optimizations/optimization_metric/explicit_route_include_objects/route_object_include_object/label_hop/te_label/direction (te-label-direction)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_direction is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_direction() directly.

    YANG Description: Label direction.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'forward': {}, 'reverse': {}},), default=six.text_type("forward"), is_leaf=True, yang_name="direction", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-label-direction', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """direction must be of a type compatible with te-label-direction""",
          'defined-type': "ietf-te-topology:te-label-direction",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'forward': {}, 'reverse': {}},), default=six.text_type("forward"), is_leaf=True, yang_name="direction", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-label-direction', is_config=True)""",
        })

    self.__direction = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_direction(self):
    self.__direction = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'forward': {}, 'reverse': {}},), default=six.text_type("forward"), is_leaf=True, yang_name="direction", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-label-direction', is_config=True)

  generic = __builtin__.property(_get_generic, _set_generic)
  otn = __builtin__.property(_get_otn, _set_otn)
  vlanid = __builtin__.property(_get_vlanid, _set_vlanid)
  direction = __builtin__.property(_get_direction, _set_direction)

  __choices__ = {'technology': {'generic': ['generic'], 'otn': ['otn'], 'eth': ['vlanid']}, 'type': {'label': ['direction']}}
  _pyangbind_elements = OrderedDict([('generic', generic), ('otn', otn), ('vlanid', vlanid), ('direction', direction), ])


