#!/bin/bash
# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

DOCKER_CONTAINER=$1
DOCKER_PORT=$2

if [ -n "$DOCKER_CONTAINER" ] && [ -n "$DOCKER_PORT" ];then
      sudo docker stop "$DOCKER_CONTAINER" -t 1
      sudo docker rm "$DOCKER_CONTAINER"

      echo "Creating TPs"
      screen -dmS t1 -T xterm sh -c "docker run -p 10.0.2.15:"$DOCKER_PORT":2022 -v ~/tfs-ctrl/tempOC/files:/files --name $DOCKER_CONTAINER -it asgamb1/oc23bgp.img:latest"
      sleep  2 
      if [ "$( docker container  inspect -f '{{.State.Running}}' "$DOCKER_CONTAINER")" = "true" ]; then 
            docker exec  "$DOCKER_CONTAINER"  cp /files/demoECOC21_4.xml demoECOC21.xml
            docker exec "$DOCKER_CONTAINER" /confd/examples.confd/OC23/startNetconfAgent.sh 
      else 
            echo "your container is not running yet"
      fi
else 
   echo "Please define the docker container name and port"
fi         
