# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import optimization_metric
from . import tiebreakers
from . import objective_function
class optimizations(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices/connectivity-matrix/optimizations. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The objective function container that includes
attributes to impose when computing a TE path.
  """
  __slots__ = ('_path_helper', '_extmethods', '__optimization_metric','__tiebreakers','__objective_function',)

  _yang_name = 'optimizations'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__optimization_metric = YANGDynClass(base=YANGListType("metric_type",optimization_metric.optimization_metric, yang_name="optimization-metric", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='metric-type', extensions=None, choice=False), is_container='list', yang_name="optimization-metric", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    self.__tiebreakers = YANGDynClass(base=tiebreakers.tiebreakers, is_container='container', yang_name="tiebreakers", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__objective_function = YANGDynClass(base=objective_function.objective_function, is_container='container', yang_name="objective-function", parent=self, choice=('algorithm', 'objective-function'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices', 'connectivity-matrix', 'optimizations']

  def _get_optimization_metric(self):
    """
    Getter method for optimization_metric, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/optimizations/optimization_metric (list)

    YANG Description: TE path metric type.
    """
    return self.__optimization_metric
      
  def _set_optimization_metric(self, v, load=False):
    """
    Setter method for optimization_metric, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/optimizations/optimization_metric (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optimization_metric is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optimization_metric() directly.

    YANG Description: TE path metric type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("metric_type",optimization_metric.optimization_metric, yang_name="optimization-metric", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='metric-type', extensions=None, choice=False), is_container='list', yang_name="optimization-metric", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optimization_metric must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("metric_type",optimization_metric.optimization_metric, yang_name="optimization-metric", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='metric-type', extensions=None, choice=False), is_container='list', yang_name="optimization-metric", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)""",
        })

    self.__optimization_metric = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optimization_metric(self):
    self.__optimization_metric = YANGDynClass(base=YANGListType("metric_type",optimization_metric.optimization_metric, yang_name="optimization-metric", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='metric-type', extensions=None, choice=False), is_container='list', yang_name="optimization-metric", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)


  def _get_tiebreakers(self):
    """
    Getter method for tiebreakers, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/optimizations/tiebreakers (container)

    YANG Description: Container for the list of tiebreakers.
    """
    return self.__tiebreakers
      
  def _set_tiebreakers(self, v, load=False):
    """
    Setter method for tiebreakers, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/optimizations/tiebreakers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tiebreakers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tiebreakers() directly.

    YANG Description: Container for the list of tiebreakers.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=tiebreakers.tiebreakers, is_container='container', yang_name="tiebreakers", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tiebreakers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=tiebreakers.tiebreakers, is_container='container', yang_name="tiebreakers", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__tiebreakers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tiebreakers(self):
    self.__tiebreakers = YANGDynClass(base=tiebreakers.tiebreakers, is_container='container', yang_name="tiebreakers", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_objective_function(self):
    """
    Getter method for objective_function, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/optimizations/objective_function (container)

    YANG Description: The objective function container that includes
attributes to impose when computing a TE path.
    """
    return self.__objective_function
      
  def _set_objective_function(self, v, load=False):
    """
    Setter method for objective_function, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/optimizations/objective_function (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_objective_function is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_objective_function() directly.

    YANG Description: The objective function container that includes
attributes to impose when computing a TE path.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=objective_function.objective_function, is_container='container', yang_name="objective-function", parent=self, choice=('algorithm', 'objective-function'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """objective_function must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=objective_function.objective_function, is_container='container', yang_name="objective-function", parent=self, choice=('algorithm', 'objective-function'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__objective_function = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_objective_function(self):
    self.__objective_function = YANGDynClass(base=objective_function.objective_function, is_container='container', yang_name="objective-function", parent=self, choice=('algorithm', 'objective-function'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  optimization_metric = __builtin__.property(_get_optimization_metric)
  tiebreakers = __builtin__.property(_get_tiebreakers)
  objective_function = __builtin__.property(_get_objective_function)

  __choices__ = {'algorithm': {'metric': ['optimization_metric', 'tiebreakers'], 'objective-function': ['objective_function']}}
  _pyangbind_elements = OrderedDict([('optimization_metric', optimization_metric), ('tiebreakers', tiebreakers), ('objective_function', objective_function), ])


