# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import templates
class te(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/te. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Indicates TE support.
  """
  __slots__ = ('_path_helper', '_extmethods', '__templates',)

  _yang_name = 'te'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__templates = YANGDynClass(base=templates.templates, is_container='container', yang_name="templates", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'te']

  def _get_templates(self):
    """
    Getter method for templates, mapped from YANG variable /networks/te/templates (container)

    YANG Description: Configuration parameters for templates used for a TE
topology.
    """
    return self.__templates
      
  def _set_templates(self, v, load=False):
    """
    Setter method for templates, mapped from YANG variable /networks/te/templates (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_templates is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_templates() directly.

    YANG Description: Configuration parameters for templates used for a TE
topology.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=templates.templates, is_container='container', yang_name="templates", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """templates must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=templates.templates, is_container='container', yang_name="templates", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__templates = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_templates(self):
    self.__templates = YANGDynClass(base=templates.templates, is_container='container', yang_name="templates", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  templates = __builtin__.property(_get_templates, _set_templates)


  _pyangbind_elements = OrderedDict([('templates', templates), ])


