# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class otn(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/label-restrictions/label-restriction/label-step/otn. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Label step for OTN
  """
  __slots__ = ('_path_helper', '_extmethods', '__tpn','__ts',)

  _yang_name = 'otn'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tpn = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="tpn", parent=self, choice=('range-type', 'trib-port'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-tpn', is_config=True)
    self.__ts = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="ts", parent=self, choice=('range-type', 'trib-slot'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-ts', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'label-restrictions', 'label-restriction', 'label-step', 'otn']

  def _get_tpn(self):
    """
    Getter method for tpn, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/label_restrictions/label_restriction/label_step/otn/tpn (otn-tpn)

    YANG Description: Label step which represents possible increments for
Tributary Port Number (TPN).
    """
    return self.__tpn
      
  def _set_tpn(self, v, load=False):
    """
    Setter method for tpn, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/label_restrictions/label_restriction/label_step/otn/tpn (otn-tpn)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tpn is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tpn() directly.

    YANG Description: Label step which represents possible increments for
Tributary Port Number (TPN).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="tpn", parent=self, choice=('range-type', 'trib-port'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-tpn', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tpn must be of a type compatible with otn-tpn""",
          'defined-type': "ietf-otn-topology:otn-tpn",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="tpn", parent=self, choice=('range-type', 'trib-port'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-tpn', is_config=True)""",
        })

    self.__tpn = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tpn(self):
    self.__tpn = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="tpn", parent=self, choice=('range-type', 'trib-port'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-tpn', is_config=True)


  def _get_ts(self):
    """
    Getter method for ts, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/label_restrictions/label_restriction/label_step/otn/ts (otn-ts)

    YANG Description: Label step which represents possible increments for
Tributary Slot (TS) number.
    """
    return self.__ts
      
  def _set_ts(self, v, load=False):
    """
    Setter method for ts, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/label_restrictions/label_restriction/label_step/otn/ts (otn-ts)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ts() directly.

    YANG Description: Label step which represents possible increments for
Tributary Slot (TS) number.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="ts", parent=self, choice=('range-type', 'trib-slot'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-ts', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ts must be of a type compatible with otn-ts""",
          'defined-type': "ietf-otn-topology:otn-ts",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="ts", parent=self, choice=('range-type', 'trib-slot'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-ts', is_config=True)""",
        })

    self.__ts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ts(self):
    self.__ts = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="ts", parent=self, choice=('range-type', 'trib-slot'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-ts', is_config=True)

  tpn = __builtin__.property(_get_tpn, _set_tpn)
  ts = __builtin__.property(_get_ts, _set_ts)

  __choices__ = {'range-type': {'trib-port': ['tpn'], 'trib-slot': ['ts']}}
  _pyangbind_elements = OrderedDict([('tpn', tpn), ('ts', ts), ])


