from typing import Any, Callable, Dict
from ._Entity import _Entity
from ...engines._DatabaseEngine import _DatabaseEngine

class _RootEntity(_Entity):
    def __init__(self, database_engine : _DatabaseEngine, entity_uuid: str, attributes_key: str,
                 attributes_validators: Dict[str, Callable[[Any], bool]],
                 attribute_transcoders: Dict[str, Dict[Any, Callable[[Any], Any]]]):
        self._database_engine = database_engine
        super().__init__(self, entity_uuid, attributes_key, attributes_validators, attribute_transcoders)

    @property
    def parent(self) -> '_RootEntity': return self

    @property
    def database_engine(self) -> _DatabaseEngine: return self._database_engine
