from typing import Dict
from ...engines._DatabaseEngine import _DatabaseEngine
from ..entity._RootEntity import _RootEntity
from ..entity.EntityCollection import EntityCollection
from .Keys import KEY_CONTEXT, KEY_TOPOLOGIES
from .Topology import Topology

VALIDATORS = {}  # no attributes accepted
TRANSCODERS = {} # no transcoding applied to attributes

class Context(_RootEntity):
    def __init__(self, context_uuid : str, database_engine : _DatabaseEngine):
        super().__init__(database_engine, context_uuid, KEY_CONTEXT, VALIDATORS, TRANSCODERS)
        self._topologies = EntityCollection(self, KEY_TOPOLOGIES)

    @property
    def parent(self) -> 'Context': return self

    @property
    def context(self) -> 'Context': return self

    @property
    def context_uuid(self) -> str: return self._entity_uuid

    @property
    def topologies(self) -> EntityCollection: return self._topologies

    def topology(self, topology_uuid : str) -> Topology: return Topology(topology_uuid, self)

    def create(self) -> 'Context': return self

    def delete(self):
        for topology_uuid in self.topologies.get(): self.topology(topology_uuid).delete()
        self.attributes.delete()

    def dump_id(self) -> Dict:
        return {
            'contextUuid': {'uuid': self.context_uuid},
        }

    def dump(self) -> Dict:
        return {topology_uuid : self.topology(topology_uuid).dump() for topology_uuid in self.topologies.get()}
