# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from sqlalchemy import Column, ForeignKey #, ForeignKeyConstraint
#from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from ._Base import _Base

# class ConnectionSubServiceModel(Model):
#     pk = PrimaryKeyField()
#     connection_fk = ForeignKeyField(ConnectionModel)
#     sub_service_fk = ForeignKeyField(ServiceModel)

class LinkEndPointModel(_Base):
    __tablename__ = 'link_endpoint'

    link_uuid     = Column(ForeignKey('link.link_uuid',         ondelete='CASCADE' ), primary_key=True)
    endpoint_uuid = Column(ForeignKey('endpoint.endpoint_uuid', ondelete='RESTRICT'), primary_key=True)

    link     = relationship('LinkModel',     back_populates='link_endpoints', lazy='joined')
    endpoint = relationship('EndPointModel', lazy='joined') # back_populates='link_endpoints'

class ServiceEndPointModel(_Base):
    __tablename__ = 'service_endpoint'

    service_uuid  = Column(ForeignKey('service.service_uuid',   ondelete='CASCADE' ), primary_key=True)
    endpoint_uuid = Column(ForeignKey('endpoint.endpoint_uuid', ondelete='RESTRICT'), primary_key=True)

    service  = relationship('ServiceModel',  back_populates='service_endpoints', lazy='joined')
    endpoint = relationship('EndPointModel', lazy='joined') # back_populates='service_endpoints'

class SliceEndPointModel(_Base):
    __tablename__ = 'slice_endpoint'

    slice_uuid    = Column(ForeignKey('slice.slice_uuid',       ondelete='CASCADE' ), primary_key=True)
    endpoint_uuid = Column(ForeignKey('endpoint.endpoint_uuid', ondelete='RESTRICT'), primary_key=True)

    slice    = relationship('SliceModel', back_populates='slice_endpoints', lazy='joined')
    endpoint = relationship('EndPointModel', lazy='joined') # back_populates='slice_endpoints'

class SliceServiceModel(_Base):
    __tablename__ = 'slice_service'

    slice_uuid   = Column(ForeignKey('slice.slice_uuid',     ondelete='CASCADE' ), primary_key=True)
    service_uuid = Column(ForeignKey('service.service_uuid', ondelete='RESTRICT'), primary_key=True)

    slice   = relationship('SliceModel', back_populates='slice_services', lazy='joined')
    service = relationship('ServiceModel', lazy='joined') # back_populates='slice_services'

#class SliceSubSliceModel(_Base):
#    __tablename__ = 'slice_subslice'
#
#    slice_uuid    = Column(ForeignKey('slice.slice_uuid', ondelete='CASCADE' ), primary_key=True)
#    subslice_uuid = Column(ForeignKey('slice.slice_uuid', ondelete='RESTRICT'), primary_key=True)
#
#    slice    = relationship('SliceModel', foreign_keys=[slice_uuid],    lazy='joined') #back_populates='slice_subslices'
#    subslice = relationship('SliceModel', foreign_keys=[subslice_uuid], lazy='joined') #back_populates='slice_subslices'

class TopologyDeviceModel(_Base):
    __tablename__ = 'topology_device'

    topology_uuid = Column(ForeignKey('topology.topology_uuid', ondelete='RESTRICT'), primary_key=True)
    device_uuid   = Column(ForeignKey('device.device_uuid',     ondelete='CASCADE' ), primary_key=True)

    #topology = relationship('TopologyModel', lazy='joined') # back_populates='topology_devices'
    device   = relationship('DeviceModel',   lazy='joined') # back_populates='topology_devices'

class TopologyLinkModel(_Base):
    __tablename__ = 'topology_link'

    topology_uuid = Column(ForeignKey('topology.topology_uuid', ondelete='RESTRICT'), primary_key=True)
    link_uuid     = Column(ForeignKey('link.link_uuid',         ondelete='CASCADE' ), primary_key=True)

    #topology = relationship('TopologyModel', lazy='joined') # back_populates='topology_links'
    link     = relationship('LinkModel',     lazy='joined') # back_populates='topology_links'
