# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import label_restrictions
class from_(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices/connectivity-matrix/from. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to a source LTP.
  """
  __slots__ = ('_path_helper', '_extmethods', '__tp_ref','__label_restrictions',)

  _yang_name = 'from'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tp_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tp-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)
    self.__label_restrictions = YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices', 'connectivity-matrix', 'from']

  def _get_tp_ref(self):
    """
    Getter method for tp_ref, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/from/tp_ref (leafref)

    YANG Description: Relative reference to a termination point.
    """
    return self.__tp_ref
      
  def _set_tp_ref(self, v, load=False):
    """
    Setter method for tp_ref, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/from/tp_ref (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tp_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tp_ref() directly.

    YANG Description: Relative reference to a termination point.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="tp-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tp_ref must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tp-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)""",
        })

    self.__tp_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tp_ref(self):
    self.__tp_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tp-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='leafref', is_config=False)


  def _get_label_restrictions(self):
    """
    Getter method for label_restrictions, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/from/label_restrictions (container)

    YANG Description: The label restrictions container.
    """
    return self.__label_restrictions
      
  def _set_label_restrictions(self, v, load=False):
    """
    Setter method for label_restrictions, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/from/label_restrictions (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_restrictions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_restrictions() directly.

    YANG Description: The label restrictions container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_restrictions must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__label_restrictions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_restrictions(self):
    self.__label_restrictions = YANGDynClass(base=label_restrictions.label_restrictions, is_container='container', yang_name="label-restrictions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  tp_ref = __builtin__.property(_get_tp_ref)
  label_restrictions = __builtin__.property(_get_label_restrictions)


  _pyangbind_elements = OrderedDict([('tp_ref', tp_ref), ('label_restrictions', label_restrictions), ])


