#!/bin/bash

# Namespace
NAMESPACE="dlt"

# Configurations
CONFIGMAP="configmap.yaml"
PV="persistent-volume.yaml"
PVC="persistent-volume-claim.yaml"
DEPLOYMENT="deployment.yaml"
SERVICE="service.yaml"

# Delete Configurations
echo "Deleting Deployment..."
kubectl delete -f $DEPLOYMENT || echo "Deployment not found."

echo "Deleting Service..."
kubectl delete -f $SERVICE || echo "Service not found."

echo "Deleting PersistentVolumeClaim..."
kubectl delete -f $PVC || echo "PersistentVolumeClaim not found."

echo "Deleting PersistentVolume..."
kubectl delete -f $PV || echo "PersistentVolume not found."

echo "Deleting ConfigMap..."
kubectl delete -f $CONFIGMAP || echo "ConfigMap not found."

# Verify Deletion
echo "Verifying Deletion..."
kubectl get pods -n $NAMESPACE
kubectl get services -n $NAMESPACE
kubectl get pvc -n $NAMESPACE
kubectl get pv
kubectl get configmap -n $NAMESPACE

echo "Deletion Completed."
