#!/bin/bash

# Namespace
NAMESPACE="dlt"

# Configurations
CONFIGMAP="configmap.yaml"
PV="persistent-volume.yaml"
PVC="persistent-volume-claim.yaml"
DEPLOYMENT="deployment.yaml"
SERVICE="service.yaml"

# Apply Configurations
echo "Applying ConfigMap..."
kubectl apply -f $CONFIGMAP

echo "Applying PersistentVolume..."
kubectl apply -f $PV

echo "Applying PersistentVolumeClaim..."
kubectl apply -f $PVC

echo "Applying Deployment..."
kubectl apply -f $DEPLOYMENT

echo "Applying Service..."
kubectl apply -f $SERVICE

# Verify Deployment
echo "Verifying Deployment..."
kubectl get pods -n $NAMESPACE
kubectl get services -n $NAMESPACE

echo "Deployment Completed."
