# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import grpc, logging
from typing import Optional
from common.Constants import DEFAULT_CONTEXT_NAME
from common.proto.context_pb2 import Service, ServiceId
from context.client.ContextClient import ContextClient

LOGGER = logging.getLogger(__name__)

def get_service(
        context_client : ContextClient, service_uuid : str, context_uuid : str = DEFAULT_CONTEXT_NAME,
        rw_copy : bool = False
    ) -> Optional[Service]:
    try:
        # pylint: disable=no-member
        service_id = ServiceId()
        service_id.context_id.context_uuid.uuid = context_uuid
        service_id.service_uuid.uuid = service_uuid
        ro_service = context_client.GetService(service_id)
        if not rw_copy: return ro_service
        rw_service = Service()
        rw_service.CopyFrom(ro_service)
        return rw_service
    except grpc.RpcError:
        #LOGGER.exception('Unable to get service({:s} / {:s})'.format(str(context_uuid), str(service_uuid)))
        return None
