/*
* Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.policy.monitoring.model;

public class AlarmDescriptor {
    private final String alarmDescription;
    private final String name;
    private final String kpiId;
    private final KpiValueRange kpiValueRange;
    private final String timestamp;

    public AlarmDescriptor(
            String alarmDescription,
            String name,
            String kpiId,
            KpiValueRange kpiValueRange,
            String timestamp) {
        this.alarmDescription = alarmDescription;
        this.name = name;
        this.kpiId = kpiId;
        this.kpiValueRange = kpiValueRange;
        this.timestamp = timestamp;
    }

    public String getAlarmDescription() {
        return alarmDescription;
    }

    public String getName() {
        return name;
    }

    public String getKpiId() {
        return kpiId;
    }

    public KpiValueRange getKpiValueRange() {
        return kpiValueRange;
    }

    public String getTimestamp() {
        return timestamp;
    }

    @Override
    public String toString() {
        return String.format(
                "%s:{alarmDescription:\"%s\", name:\"%s\", kpiId:\"%s\", %s, timestamp:\"%s\"}",
                getClass().getSimpleName(), alarmDescription, name, kpiId, kpiValueRange, timestamp);
    }
}
