# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import supporting_node
from . import termination_point
from . import te
class node(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The inventory of nodes of this network.
  """
  __slots__ = ('_path_helper', '_extmethods', '__node_id','__supporting_node','__termination_point','__te_node_id','__te',)

  _yang_name = 'node'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__node_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='node-id', is_config=True)
    self.__supporting_node = YANGDynClass(base=YANGListType("network_ref node_ref",supporting_node.supporting_node, yang_name="supporting-node", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref node-ref', extensions=None), is_container='list', yang_name="supporting-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)
    self.__termination_point = YANGDynClass(base=YANGListType("tp_id",termination_point.termination_point, yang_name="termination-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tp-id', extensions=None), is_container='list', yang_name="termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)
    self.__te_node_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])'}), is_leaf=True, yang_name="te-node-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-node-id', is_config=True)
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node']

  def _get_node_id(self):
    """
    Getter method for node_id, mapped from YANG variable /networks/network/node/node_id (node-id)

    YANG Description: Uniquely identifies a node within the containing
network.
    """
    return self.__node_id
      
  def _set_node_id(self, v, load=False):
    """
    Setter method for node_id, mapped from YANG variable /networks/network/node/node_id (node-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_node_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_node_id() directly.

    YANG Description: Uniquely identifies a node within the containing
network.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="node-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='node-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """node_id must be of a type compatible with node-id""",
          'defined-type': "ietf-network:node-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='node-id', is_config=True)""",
        })

    self.__node_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_node_id(self):
    self.__node_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='node-id', is_config=True)


  def _get_supporting_node(self):
    """
    Getter method for supporting_node, mapped from YANG variable /networks/network/node/supporting_node (list)

    YANG Description: Represents another node that is in an underlay network
and that supports this node.  Used to represent layering
structure.
    """
    return self.__supporting_node
      
  def _set_supporting_node(self, v, load=False):
    """
    Setter method for supporting_node, mapped from YANG variable /networks/network/node/supporting_node (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_supporting_node is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_supporting_node() directly.

    YANG Description: Represents another node that is in an underlay network
and that supports this node.  Used to represent layering
structure.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("network_ref node_ref",supporting_node.supporting_node, yang_name="supporting-node", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref node-ref', extensions=None), is_container='list', yang_name="supporting-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """supporting_node must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("network_ref node_ref",supporting_node.supporting_node, yang_name="supporting-node", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref node-ref', extensions=None), is_container='list', yang_name="supporting-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)""",
        })

    self.__supporting_node = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_supporting_node(self):
    self.__supporting_node = YANGDynClass(base=YANGListType("network_ref node_ref",supporting_node.supporting_node, yang_name="supporting-node", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='network-ref node-ref', extensions=None), is_container='list', yang_name="supporting-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network', defining_module='ietf-network', yang_type='list', is_config=True)


  def _get_termination_point(self):
    """
    Getter method for termination_point, mapped from YANG variable /networks/network/node/termination_point (list)

    YANG Description: A termination point can terminate a link.
Depending on the type of topology, a termination point
could, for example, refer to a port or an interface.
    """
    return self.__termination_point
      
  def _set_termination_point(self, v, load=False):
    """
    Setter method for termination_point, mapped from YANG variable /networks/network/node/termination_point (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_termination_point is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_termination_point() directly.

    YANG Description: A termination point can terminate a link.
Depending on the type of topology, a termination point
could, for example, refer to a port or an interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("tp_id",termination_point.termination_point, yang_name="termination-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tp-id', extensions=None), is_container='list', yang_name="termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """termination_point must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("tp_id",termination_point.termination_point, yang_name="termination-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tp-id', extensions=None), is_container='list', yang_name="termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)""",
        })

    self.__termination_point = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_termination_point(self):
    self.__termination_point = YANGDynClass(base=YANGListType("tp_id",termination_point.termination_point, yang_name="termination-point", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tp-id', extensions=None), is_container='list', yang_name="termination-point", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='list', is_config=True)


  def _get_te_node_id(self):
    """
    Getter method for te_node_id, mapped from YANG variable /networks/network/node/te_node_id (te-types:te-node-id)

    YANG Description: The identifier of a node in the TE topology.
A node is specific to a topology to which it belongs.
    """
    return self.__te_node_id
      
  def _set_te_node_id(self, v, load=False):
    """
    Setter method for te_node_id, mapped from YANG variable /networks/network/node/te_node_id (te-types:te-node-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_node_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_node_id() directly.

    YANG Description: The identifier of a node in the TE topology.
A node is specific to a topology to which it belongs.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])'}), is_leaf=True, yang_name="te-node-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-node-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_node_id must be of a type compatible with te-types:te-node-id""",
          'defined-type': "te-types:te-node-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])'}), is_leaf=True, yang_name="te-node-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-node-id', is_config=True)""",
        })

    self.__te_node_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_node_id(self):
    self.__te_node_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])'}), is_leaf=True, yang_name="te-node-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-node-id', is_config=True)


  def _get_te(self):
    """
    Getter method for te, mapped from YANG variable /networks/network/node/te (container)

    YANG Description: Indicates TE support.
    """
    return self.__te
      
  def _set_te(self, v, load=False):
    """
    Setter method for te, mapped from YANG variable /networks/network/node/te (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te() directly.

    YANG Description: Indicates TE support.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__te = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te(self):
    self.__te = YANGDynClass(base=te.te, is_container='container', yang_name="te", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  node_id = __builtin__.property(_get_node_id, _set_node_id)
  supporting_node = __builtin__.property(_get_supporting_node, _set_supporting_node)
  termination_point = __builtin__.property(_get_termination_point, _set_termination_point)
  te_node_id = __builtin__.property(_get_te_node_id, _set_te_node_id)
  te = __builtin__.property(_get_te, _set_te)


  _pyangbind_elements = OrderedDict([('node_id', node_id), ('supporting_node', supporting_node), ('termination_point', termination_point), ('te_node_id', te_node_id), ('te', te), ])


