# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from sqlalchemy.engine import Engine
from sqlalchemy.orm import Session, sessionmaker
from sqlalchemy_cockroachdb import run_transaction
from typing import Dict, List
from common.proto.context_pb2 import EndPointIdList
from .models.EndPointModel import EndPointModel
from .uuids.EndPoint import endpoint_get_uuid

LOGGER = logging.getLogger(__name__)

def endpoint_list_names(db_engine : Engine, request : EndPointIdList) -> List[Dict]:
    endpoint_uuids = {
        endpoint_get_uuid(endpoint_id, allow_random=False)[-1]
        for endpoint_id in request.endpoint_ids
    }
    def callback(session : Session) -> List[Dict]:
        obj_list : List[EndPointModel] = \
            session.query(EndPointModel).filter(EndPointModel.endpoint_uuid.in_(endpoint_uuids)).all()
        return [obj.dump_name() for obj in obj_list]
    return run_transaction(sessionmaker(bind=db_engine), callback)
