import sys
import grpc

import monitoring_pb2 as monitoring
import monitoring_pb2_grpc
import context_pb2

import json

from logger import getJSONLogger
logger = getJSONLogger('monitoring-client')
logger.setLevel('DEBUG')

class MonitoringClient:

    def __init__(self, server="monitoring", port="7070"):
        logger.info("init monitoringClient port " + port)
        self.channel=grpc.insecure_channel(server+':'+port)
        self.server=monitoring_pb2_grpc.MonitoringServiceStub(self.channel)

    def IncludeKpi(self, request):
        logger.info("IncludeKpi: {}".format(request))
        response = self.server.IncludeKpi(request)
        logger.info("IncludeKpi result: {}".format(response))
        return context_pb2.Empty()

    def MonitorKpi(self, request):
        logger.info("MonitorKpi: {}".format(request))
        response = self.server.IncludeKpi(request)
        logger.info("MonitorKpi result: {}".format(response))
        return context_pb2.Empty()
        
    def GetStream_kpi(self, request):
        logger.info("GetStream_kpi: {}".format(request))
        response = self.server.GetStream_kpi(request)
        logger.info("GetStream_kpi result: {}".format(response))
        yield response

    def GetInstantKpi(self, request):
        logger.info("GetInstantKpi: {}".format(request))
        response = self.server.IncludeKpi(request)
        logger.info("GetInstantKpi result: {}".format(response))
        return response
        

if __name__ == "__main__":
    # get port
    if len(sys.argv) > 1:
        port = sys.argv[1]
    else:
        port = "7070"

    # form request
    kpi = monitoring.Kpi()
    kpi.kpi_id.kpi_id = "KPIID0000"
    kpi.kpiDescription = "KPI Desc"

    # make call to server
    client = MonitoringClient(port)
    response=client.IncludeKpi(kpi)
