# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_path_objective_function import TapiPathComputationPathObjectiveFunction  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_path_optimization_constraint import TapiPathComputationPathOptimizationConstraint  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_path_ref import TapiPathComputationPathRef  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_path_service_end_point import TapiPathComputationPathServiceEndPoint  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_routing_constraint import TapiPathComputationRoutingConstraint  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_topology_constraint import TapiPathComputationTopologyConstraint  # noqa: F401,E501
from tapi_server import util


class TapiPathComputationPathComputationService(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, uuid: str=None, topology_constraint: TapiPathComputationTopologyConstraint=None, path: List[TapiPathComputationPathRef]=None, objective_function: TapiPathComputationPathObjectiveFunction=None, end_point: List[TapiPathComputationPathServiceEndPoint]=None, routing_constraint: TapiPathComputationRoutingConstraint=None, optimization_constraint: TapiPathComputationPathOptimizationConstraint=None):  # noqa: E501
        """TapiPathComputationPathComputationService - a model defined in Swagger

        :param name: The name of this TapiPathComputationPathComputationService.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiPathComputationPathComputationService.  # noqa: E501
        :type uuid: str
        :param topology_constraint: The topology_constraint of this TapiPathComputationPathComputationService.  # noqa: E501
        :type topology_constraint: TapiPathComputationTopologyConstraint
        :param path: The path of this TapiPathComputationPathComputationService.  # noqa: E501
        :type path: List[TapiPathComputationPathRef]
        :param objective_function: The objective_function of this TapiPathComputationPathComputationService.  # noqa: E501
        :type objective_function: TapiPathComputationPathObjectiveFunction
        :param end_point: The end_point of this TapiPathComputationPathComputationService.  # noqa: E501
        :type end_point: List[TapiPathComputationPathServiceEndPoint]
        :param routing_constraint: The routing_constraint of this TapiPathComputationPathComputationService.  # noqa: E501
        :type routing_constraint: TapiPathComputationRoutingConstraint
        :param optimization_constraint: The optimization_constraint of this TapiPathComputationPathComputationService.  # noqa: E501
        :type optimization_constraint: TapiPathComputationPathOptimizationConstraint
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'topology_constraint': TapiPathComputationTopologyConstraint,
            'path': List[TapiPathComputationPathRef],
            'objective_function': TapiPathComputationPathObjectiveFunction,
            'end_point': List[TapiPathComputationPathServiceEndPoint],
            'routing_constraint': TapiPathComputationRoutingConstraint,
            'optimization_constraint': TapiPathComputationPathOptimizationConstraint
        }

        self.attribute_map = {
            'name': 'name',
            'uuid': 'uuid',
            'topology_constraint': 'topology-constraint',
            'path': 'path',
            'objective_function': 'objective-function',
            'end_point': 'end-point',
            'routing_constraint': 'routing-constraint',
            'optimization_constraint': 'optimization-constraint'
        }
        self._name = name
        self._uuid = uuid
        self._topology_constraint = topology_constraint
        self._path = path
        self._objective_function = objective_function
        self._end_point = end_point
        self._routing_constraint = routing_constraint
        self._optimization_constraint = optimization_constraint

    @classmethod
    def from_dict(cls, dikt) -> 'TapiPathComputationPathComputationService':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.path.computation.PathComputationService of this TapiPathComputationPathComputationService.  # noqa: E501
        :rtype: TapiPathComputationPathComputationService
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiPathComputationPathComputationService.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiPathComputationPathComputationService.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiPathComputationPathComputationService.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiPathComputationPathComputationService.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiPathComputationPathComputationService.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiPathComputationPathComputationService.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiPathComputationPathComputationService.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiPathComputationPathComputationService.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def topology_constraint(self) -> TapiPathComputationTopologyConstraint:
        """Gets the topology_constraint of this TapiPathComputationPathComputationService.


        :return: The topology_constraint of this TapiPathComputationPathComputationService.
        :rtype: TapiPathComputationTopologyConstraint
        """
        return self._topology_constraint

    @topology_constraint.setter
    def topology_constraint(self, topology_constraint: TapiPathComputationTopologyConstraint):
        """Sets the topology_constraint of this TapiPathComputationPathComputationService.


        :param topology_constraint: The topology_constraint of this TapiPathComputationPathComputationService.
        :type topology_constraint: TapiPathComputationTopologyConstraint
        """

        self._topology_constraint = topology_constraint

    @property
    def path(self) -> List[TapiPathComputationPathRef]:
        """Gets the path of this TapiPathComputationPathComputationService.

        none  # noqa: E501

        :return: The path of this TapiPathComputationPathComputationService.
        :rtype: List[TapiPathComputationPathRef]
        """
        return self._path

    @path.setter
    def path(self, path: List[TapiPathComputationPathRef]):
        """Sets the path of this TapiPathComputationPathComputationService.

        none  # noqa: E501

        :param path: The path of this TapiPathComputationPathComputationService.
        :type path: List[TapiPathComputationPathRef]
        """

        self._path = path

    @property
    def objective_function(self) -> TapiPathComputationPathObjectiveFunction:
        """Gets the objective_function of this TapiPathComputationPathComputationService.


        :return: The objective_function of this TapiPathComputationPathComputationService.
        :rtype: TapiPathComputationPathObjectiveFunction
        """
        return self._objective_function

    @objective_function.setter
    def objective_function(self, objective_function: TapiPathComputationPathObjectiveFunction):
        """Sets the objective_function of this TapiPathComputationPathComputationService.


        :param objective_function: The objective_function of this TapiPathComputationPathComputationService.
        :type objective_function: TapiPathComputationPathObjectiveFunction
        """

        self._objective_function = objective_function

    @property
    def end_point(self) -> List[TapiPathComputationPathServiceEndPoint]:
        """Gets the end_point of this TapiPathComputationPathComputationService.

        none  # noqa: E501

        :return: The end_point of this TapiPathComputationPathComputationService.
        :rtype: List[TapiPathComputationPathServiceEndPoint]
        """
        return self._end_point

    @end_point.setter
    def end_point(self, end_point: List[TapiPathComputationPathServiceEndPoint]):
        """Sets the end_point of this TapiPathComputationPathComputationService.

        none  # noqa: E501

        :param end_point: The end_point of this TapiPathComputationPathComputationService.
        :type end_point: List[TapiPathComputationPathServiceEndPoint]
        """

        self._end_point = end_point

    @property
    def routing_constraint(self) -> TapiPathComputationRoutingConstraint:
        """Gets the routing_constraint of this TapiPathComputationPathComputationService.


        :return: The routing_constraint of this TapiPathComputationPathComputationService.
        :rtype: TapiPathComputationRoutingConstraint
        """
        return self._routing_constraint

    @routing_constraint.setter
    def routing_constraint(self, routing_constraint: TapiPathComputationRoutingConstraint):
        """Sets the routing_constraint of this TapiPathComputationPathComputationService.


        :param routing_constraint: The routing_constraint of this TapiPathComputationPathComputationService.
        :type routing_constraint: TapiPathComputationRoutingConstraint
        """

        self._routing_constraint = routing_constraint

    @property
    def optimization_constraint(self) -> TapiPathComputationPathOptimizationConstraint:
        """Gets the optimization_constraint of this TapiPathComputationPathComputationService.


        :return: The optimization_constraint of this TapiPathComputationPathComputationService.
        :rtype: TapiPathComputationPathOptimizationConstraint
        """
        return self._optimization_constraint

    @optimization_constraint.setter
    def optimization_constraint(self, optimization_constraint: TapiPathComputationPathOptimizationConstraint):
        """Sets the optimization_constraint of this TapiPathComputationPathComputationService.


        :param optimization_constraint: The optimization_constraint of this TapiPathComputationPathComputationService.
        :type optimization_constraint: TapiPathComputationPathOptimizationConstraint
        """

        self._optimization_constraint = optimization_constraint
