# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import Dict, Final, Iterator, List, Tuple

from .. import (
    YANGChoice, YANGChoiceCase, YANGContainer, YANGContainerMember,
    YANGLeafMember, YANGListItem, YANGListMember)


class PathAffinitiesValueMeta(type):
    """
    Metaclass for YANG list item handler.

    YANG name: path-affinities-value
    """

    class yang_list_descriptor(
            YANGListMember):
        """
        YANG list descriptor class.

        YANG name: path-affinities-value
        """

        def __init__(self):
            super().__init__(PathAffinitiesValue)

        def __get__(self, instance, owner=None) -> (
                'PathAffinitiesValueMeta.yang_list_descriptor'):
            return super().__get__(instance, owner)

        def __call__(self) -> List['PathAffinitiesValue']:
            pass

        def __iter__(self, key) -> Iterator['PathAffinitiesValue']:
            return super().__iter__()

        def __getitem__(self, key) -> 'PathAffinitiesValue':
            return super()[key]

        def __enter__(self) -> (
                'PathAffinitiesValueMeta.yang_list_descriptor'):
            pass


class PathAffinitiesValue(
        YANGListItem,
        metaclass=PathAffinitiesValueMeta):
    """
    YANG list item handler.

    YANG name: path-affinities-value
    """

    _yang_name: Final[str] = 'path-affinities-value'
    _yang_namespace: Final[str] = 'urn:ietf:params:xml:ns:yang:ietf-te-topology'
    _yang_module_name: Final[str] = 'ietf-te-topology'

    _yang_list_key_names: Final[Tuple[str]] = (
        'usage',
    )

    _yang_leaf_members: Final[Dict[str, YANGLeafMember]] = {

        'value': (
            value := YANGLeafMember(
                'value',
                'urn:ietf:params:xml:ns:yang:ietf-te-topology',
                'ietf-te-topology')),

        'usage': (
            usage := YANGLeafMember(
                'usage',
                'urn:ietf:params:xml:ns:yang:ietf-te-topology',
                'ietf-te-topology')),
    }

    _yang_container_members: Final[Dict[str, YANGContainerMember]] = {
    }

    _yang_list_members: Final[Dict[str, YANGListMember]] = {
    }

    _yang_choices: Final[Dict[str, YANGChoice]] = None

    def __new__(cls, *args, **kwargs) -> 'PathAffinitiesValue':
        instance = super().__new__(cls)
        instance._yang_choices = {
        }
        return instance
