# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import route_object_exclude_object
class explicit_route_exclude_objects(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/optimizations/optimization-metric/explicit-route-exclude-objects. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for the 'exclude route' object list.
  """
  __slots__ = ('_path_helper', '_extmethods', '__route_object_exclude_object',)

  _yang_name = 'explicit-route-exclude-objects'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__route_object_exclude_object = YANGDynClass(base=YANGListType("index",route_object_exclude_object.route_object_exclude_object, yang_name="route-object-exclude-object", parent=self, is_container='list', user_ordered=True, path_helper=self._path_helper, yang_keys='index', extensions=None, choice=('algorithm', 'metric')), is_container='list', yang_name="route-object-exclude-object", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'optimizations', 'optimization-metric', 'explicit-route-exclude-objects']

  def _get_route_object_exclude_object(self):
    """
    Getter method for route_object_exclude_object, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/explicit_route_exclude_objects/route_object_exclude_object (list)

    YANG Description: List of Explicit Route Objects to be excluded in the
path computation.
    """
    return self.__route_object_exclude_object
      
  def _set_route_object_exclude_object(self, v, load=False):
    """
    Setter method for route_object_exclude_object, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/optimizations/optimization_metric/explicit_route_exclude_objects/route_object_exclude_object (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_route_object_exclude_object is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_route_object_exclude_object() directly.

    YANG Description: List of Explicit Route Objects to be excluded in the
path computation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",route_object_exclude_object.route_object_exclude_object, yang_name="route-object-exclude-object", parent=self, is_container='list', user_ordered=True, path_helper=self._path_helper, yang_keys='index', extensions=None, choice=('algorithm', 'metric')), is_container='list', yang_name="route-object-exclude-object", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """route_object_exclude_object must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",route_object_exclude_object.route_object_exclude_object, yang_name="route-object-exclude-object", parent=self, is_container='list', user_ordered=True, path_helper=self._path_helper, yang_keys='index', extensions=None, choice=('algorithm', 'metric')), is_container='list', yang_name="route-object-exclude-object", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__route_object_exclude_object = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_route_object_exclude_object(self):
    self.__route_object_exclude_object = YANGDynClass(base=YANGListType("index",route_object_exclude_object.route_object_exclude_object, yang_name="route-object-exclude-object", parent=self, is_container='list', user_ordered=True, path_helper=self._path_helper, yang_keys='index', extensions=None, choice=('algorithm', 'metric')), is_container='list', yang_name="route-object-exclude-object", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

  route_object_exclude_object = __builtin__.property(_get_route_object_exclude_object, _set_route_object_exclude_object)

  __choices__ = {'algorithm': {'metric': ['route_object_exclude_object']}}
  _pyangbind_elements = OrderedDict([('route_object_exclude_object', route_object_exclude_object), ])


