from enum import Enum
from service.service.database.ServiceModel import ORM_ServiceTypeEnum
from service.service.database.DeviceModel import ORM_DeviceDriverEnum

class FilterFieldEnum(Enum):
    SERVICE_TYPE  = 'service_type'
    DEVICE_DRIVER = 'device_driver'

# Map allowed filter fields to allowed values per Filter field. If no restriction (free text) None is specified
FILTER_FIELD_ALLOWED_VALUES = {
    FilterFieldEnum.SERVICE_TYPE.value  : {i.value for i in ORM_ServiceTypeEnum},
    FilterFieldEnum.DEVICE_DRIVER.value : {i.value for i in ORM_DeviceDriverEnum},
}
