# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server import util


class TapiTopologyTransferIntegrityPac(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, error_characteristic: str=None, unavailable_time_characteristic: str=None, server_integrity_process_characteristic: str=None, delivery_order_characteristic: str=None, repeat_delivery_characteristic: str=None, loss_characteristic: str=None):  # noqa: E501
        """TapiTopologyTransferIntegrityPac - a model defined in Swagger

        :param error_characteristic: The error_characteristic of this TapiTopologyTransferIntegrityPac.  # noqa: E501
        :type error_characteristic: str
        :param unavailable_time_characteristic: The unavailable_time_characteristic of this TapiTopologyTransferIntegrityPac.  # noqa: E501
        :type unavailable_time_characteristic: str
        :param server_integrity_process_characteristic: The server_integrity_process_characteristic of this TapiTopologyTransferIntegrityPac.  # noqa: E501
        :type server_integrity_process_characteristic: str
        :param delivery_order_characteristic: The delivery_order_characteristic of this TapiTopologyTransferIntegrityPac.  # noqa: E501
        :type delivery_order_characteristic: str
        :param repeat_delivery_characteristic: The repeat_delivery_characteristic of this TapiTopologyTransferIntegrityPac.  # noqa: E501
        :type repeat_delivery_characteristic: str
        :param loss_characteristic: The loss_characteristic of this TapiTopologyTransferIntegrityPac.  # noqa: E501
        :type loss_characteristic: str
        """
        self.swagger_types = {
            'error_characteristic': str,
            'unavailable_time_characteristic': str,
            'server_integrity_process_characteristic': str,
            'delivery_order_characteristic': str,
            'repeat_delivery_characteristic': str,
            'loss_characteristic': str
        }

        self.attribute_map = {
            'error_characteristic': 'error-characteristic',
            'unavailable_time_characteristic': 'unavailable-time-characteristic',
            'server_integrity_process_characteristic': 'server-integrity-process-characteristic',
            'delivery_order_characteristic': 'delivery-order-characteristic',
            'repeat_delivery_characteristic': 'repeat-delivery-characteristic',
            'loss_characteristic': 'loss-characteristic'
        }
        self._error_characteristic = error_characteristic
        self._unavailable_time_characteristic = unavailable_time_characteristic
        self._server_integrity_process_characteristic = server_integrity_process_characteristic
        self._delivery_order_characteristic = delivery_order_characteristic
        self._repeat_delivery_characteristic = repeat_delivery_characteristic
        self._loss_characteristic = loss_characteristic

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyTransferIntegrityPac':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.TransferIntegrityPac of this TapiTopologyTransferIntegrityPac.  # noqa: E501
        :rtype: TapiTopologyTransferIntegrityPac
        """
        return util.deserialize_model(dikt, cls)

    @property
    def error_characteristic(self) -> str:
        """Gets the error_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the degree to which the signal propagated can be errored.                  Applies to TDM systems as the errored signal will be propagated and not packet as errored packets will be discarded.  # noqa: E501

        :return: The error_characteristic of this TapiTopologyTransferIntegrityPac.
        :rtype: str
        """
        return self._error_characteristic

    @error_characteristic.setter
    def error_characteristic(self, error_characteristic: str):
        """Sets the error_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the degree to which the signal propagated can be errored.                  Applies to TDM systems as the errored signal will be propagated and not packet as errored packets will be discarded.  # noqa: E501

        :param error_characteristic: The error_characteristic of this TapiTopologyTransferIntegrityPac.
        :type error_characteristic: str
        """

        self._error_characteristic = error_characteristic

    @property
    def unavailable_time_characteristic(self) -> str:
        """Gets the unavailable_time_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the duration for which there may be no valid signal propagated.  # noqa: E501

        :return: The unavailable_time_characteristic of this TapiTopologyTransferIntegrityPac.
        :rtype: str
        """
        return self._unavailable_time_characteristic

    @unavailable_time_characteristic.setter
    def unavailable_time_characteristic(self, unavailable_time_characteristic: str):
        """Sets the unavailable_time_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the duration for which there may be no valid signal propagated.  # noqa: E501

        :param unavailable_time_characteristic: The unavailable_time_characteristic of this TapiTopologyTransferIntegrityPac.
        :type unavailable_time_characteristic: str
        """

        self._unavailable_time_characteristic = unavailable_time_characteristic

    @property
    def server_integrity_process_characteristic(self) -> str:
        """Gets the server_integrity_process_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the effect of any server integrity enhancement process on the characteristics of the TopologicalEntity.  # noqa: E501

        :return: The server_integrity_process_characteristic of this TapiTopologyTransferIntegrityPac.
        :rtype: str
        """
        return self._server_integrity_process_characteristic

    @server_integrity_process_characteristic.setter
    def server_integrity_process_characteristic(self, server_integrity_process_characteristic: str):
        """Sets the server_integrity_process_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the effect of any server integrity enhancement process on the characteristics of the TopologicalEntity.  # noqa: E501

        :param server_integrity_process_characteristic: The server_integrity_process_characteristic of this TapiTopologyTransferIntegrityPac.
        :type server_integrity_process_characteristic: str
        """

        self._server_integrity_process_characteristic = server_integrity_process_characteristic

    @property
    def delivery_order_characteristic(self) -> str:
        """Gets the delivery_order_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the degree to which packets will be delivered out of sequence.                  Does not apply to TDM as the TDM protocols maintain strict order.  # noqa: E501

        :return: The delivery_order_characteristic of this TapiTopologyTransferIntegrityPac.
        :rtype: str
        """
        return self._delivery_order_characteristic

    @delivery_order_characteristic.setter
    def delivery_order_characteristic(self, delivery_order_characteristic: str):
        """Sets the delivery_order_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the degree to which packets will be delivered out of sequence.                  Does not apply to TDM as the TDM protocols maintain strict order.  # noqa: E501

        :param delivery_order_characteristic: The delivery_order_characteristic of this TapiTopologyTransferIntegrityPac.
        :type delivery_order_characteristic: str
        """

        self._delivery_order_characteristic = delivery_order_characteristic

    @property
    def repeat_delivery_characteristic(self) -> str:
        """Gets the repeat_delivery_characteristic of this TapiTopologyTransferIntegrityPac.

        Primarily applies to packet systems where a packet may be delivered more than once (in fault recovery for example).                  It can also apply to TDM where several frames may be received twice due to switching in a system with a large differential propagation delay.  # noqa: E501

        :return: The repeat_delivery_characteristic of this TapiTopologyTransferIntegrityPac.
        :rtype: str
        """
        return self._repeat_delivery_characteristic

    @repeat_delivery_characteristic.setter
    def repeat_delivery_characteristic(self, repeat_delivery_characteristic: str):
        """Sets the repeat_delivery_characteristic of this TapiTopologyTransferIntegrityPac.

        Primarily applies to packet systems where a packet may be delivered more than once (in fault recovery for example).                  It can also apply to TDM where several frames may be received twice due to switching in a system with a large differential propagation delay.  # noqa: E501

        :param repeat_delivery_characteristic: The repeat_delivery_characteristic of this TapiTopologyTransferIntegrityPac.
        :type repeat_delivery_characteristic: str
        """

        self._repeat_delivery_characteristic = repeat_delivery_characteristic

    @property
    def loss_characteristic(self) -> str:
        """Gets the loss_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the acceptable characteristic of lost packets where loss may result from discard due to errors or overflow.                  Applies to packet systems and not TDM (as for TDM errored signals are propagated unless grossly errored and overflow/underflow turns into timing slips).  # noqa: E501

        :return: The loss_characteristic of this TapiTopologyTransferIntegrityPac.
        :rtype: str
        """
        return self._loss_characteristic

    @loss_characteristic.setter
    def loss_characteristic(self, loss_characteristic: str):
        """Sets the loss_characteristic of this TapiTopologyTransferIntegrityPac.

        Describes the acceptable characteristic of lost packets where loss may result from discard due to errors or overflow.                  Applies to packet systems and not TDM (as for TDM errored signals are propagated unless grossly errored and overflow/underflow turns into timing slips).  # noqa: E501

        :param loss_characteristic: The loss_characteristic of this TapiTopologyTransferIntegrityPac.
        :type loss_characteristic: str
        """

        self._loss_characteristic = loss_characteristic
