# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server import util


class TapiPathComputationTopologyConstraint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, include_node: List[str]=None, exclude_link: List[str]=None, avoid_topology: List[str]=None, exclude_path: List[str]=None, include_link: List[str]=None, preferred_transport_layer: List[TapiCommonLayerProtocolName]=None, exclude_node: List[str]=None, include_topology: List[str]=None, include_path: List[str]=None):  # noqa: E501
        """TapiPathComputationTopologyConstraint - a model defined in Swagger

        :param include_node: The include_node of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type include_node: List[str]
        :param exclude_link: The exclude_link of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type exclude_link: List[str]
        :param avoid_topology: The avoid_topology of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type avoid_topology: List[str]
        :param exclude_path: The exclude_path of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type exclude_path: List[str]
        :param include_link: The include_link of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type include_link: List[str]
        :param preferred_transport_layer: The preferred_transport_layer of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type preferred_transport_layer: List[TapiCommonLayerProtocolName]
        :param exclude_node: The exclude_node of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type exclude_node: List[str]
        :param include_topology: The include_topology of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type include_topology: List[str]
        :param include_path: The include_path of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :type include_path: List[str]
        """
        self.swagger_types = {
            'include_node': List[str],
            'exclude_link': List[str],
            'avoid_topology': List[str],
            'exclude_path': List[str],
            'include_link': List[str],
            'preferred_transport_layer': List[TapiCommonLayerProtocolName],
            'exclude_node': List[str],
            'include_topology': List[str],
            'include_path': List[str]
        }

        self.attribute_map = {
            'include_node': 'include-node',
            'exclude_link': 'exclude-link',
            'avoid_topology': 'avoid-topology',
            'exclude_path': 'exclude-path',
            'include_link': 'include-link',
            'preferred_transport_layer': 'preferred-transport-layer',
            'exclude_node': 'exclude-node',
            'include_topology': 'include-topology',
            'include_path': 'include-path'
        }
        self._include_node = include_node
        self._exclude_link = exclude_link
        self._avoid_topology = avoid_topology
        self._exclude_path = exclude_path
        self._include_link = include_link
        self._preferred_transport_layer = preferred_transport_layer
        self._exclude_node = exclude_node
        self._include_topology = include_topology
        self._include_path = include_path

    @classmethod
    def from_dict(cls, dikt) -> 'TapiPathComputationTopologyConstraint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.path.computation.TopologyConstraint of this TapiPathComputationTopologyConstraint.  # noqa: E501
        :rtype: TapiPathComputationTopologyConstraint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def include_node(self) -> List[str]:
        """Gets the include_node of this TapiPathComputationTopologyConstraint.

        This is a loose constraint - that is it is unordered and could be a partial list  # noqa: E501

        :return: The include_node of this TapiPathComputationTopologyConstraint.
        :rtype: List[str]
        """
        return self._include_node

    @include_node.setter
    def include_node(self, include_node: List[str]):
        """Sets the include_node of this TapiPathComputationTopologyConstraint.

        This is a loose constraint - that is it is unordered and could be a partial list  # noqa: E501

        :param include_node: The include_node of this TapiPathComputationTopologyConstraint.
        :type include_node: List[str]
        """

        self._include_node = include_node

    @property
    def exclude_link(self) -> List[str]:
        """Gets the exclude_link of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :return: The exclude_link of this TapiPathComputationTopologyConstraint.
        :rtype: List[str]
        """
        return self._exclude_link

    @exclude_link.setter
    def exclude_link(self, exclude_link: List[str]):
        """Sets the exclude_link of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :param exclude_link: The exclude_link of this TapiPathComputationTopologyConstraint.
        :type exclude_link: List[str]
        """

        self._exclude_link = exclude_link

    @property
    def avoid_topology(self) -> List[str]:
        """Gets the avoid_topology of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :return: The avoid_topology of this TapiPathComputationTopologyConstraint.
        :rtype: List[str]
        """
        return self._avoid_topology

    @avoid_topology.setter
    def avoid_topology(self, avoid_topology: List[str]):
        """Sets the avoid_topology of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :param avoid_topology: The avoid_topology of this TapiPathComputationTopologyConstraint.
        :type avoid_topology: List[str]
        """

        self._avoid_topology = avoid_topology

    @property
    def exclude_path(self) -> List[str]:
        """Gets the exclude_path of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :return: The exclude_path of this TapiPathComputationTopologyConstraint.
        :rtype: List[str]
        """
        return self._exclude_path

    @exclude_path.setter
    def exclude_path(self, exclude_path: List[str]):
        """Sets the exclude_path of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :param exclude_path: The exclude_path of this TapiPathComputationTopologyConstraint.
        :type exclude_path: List[str]
        """

        self._exclude_path = exclude_path

    @property
    def include_link(self) -> List[str]:
        """Gets the include_link of this TapiPathComputationTopologyConstraint.

        This is a loose constraint - that is it is unordered and could be a partial list   # noqa: E501

        :return: The include_link of this TapiPathComputationTopologyConstraint.
        :rtype: List[str]
        """
        return self._include_link

    @include_link.setter
    def include_link(self, include_link: List[str]):
        """Sets the include_link of this TapiPathComputationTopologyConstraint.

        This is a loose constraint - that is it is unordered and could be a partial list   # noqa: E501

        :param include_link: The include_link of this TapiPathComputationTopologyConstraint.
        :type include_link: List[str]
        """

        self._include_link = include_link

    @property
    def preferred_transport_layer(self) -> List[TapiCommonLayerProtocolName]:
        """Gets the preferred_transport_layer of this TapiPathComputationTopologyConstraint.

        soft constraint requested by client to indicate the layer(s) of transport connection that it prefers to carry the service. This could be same as the service layer or one of the supported server layers  # noqa: E501

        :return: The preferred_transport_layer of this TapiPathComputationTopologyConstraint.
        :rtype: List[TapiCommonLayerProtocolName]
        """
        return self._preferred_transport_layer

    @preferred_transport_layer.setter
    def preferred_transport_layer(self, preferred_transport_layer: List[TapiCommonLayerProtocolName]):
        """Sets the preferred_transport_layer of this TapiPathComputationTopologyConstraint.

        soft constraint requested by client to indicate the layer(s) of transport connection that it prefers to carry the service. This could be same as the service layer or one of the supported server layers  # noqa: E501

        :param preferred_transport_layer: The preferred_transport_layer of this TapiPathComputationTopologyConstraint.
        :type preferred_transport_layer: List[TapiCommonLayerProtocolName]
        """

        self._preferred_transport_layer = preferred_transport_layer

    @property
    def exclude_node(self) -> List[str]:
        """Gets the exclude_node of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :return: The exclude_node of this TapiPathComputationTopologyConstraint.
        :rtype: List[str]
        """
        return self._exclude_node

    @exclude_node.setter
    def exclude_node(self, exclude_node: List[str]):
        """Sets the exclude_node of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :param exclude_node: The exclude_node of this TapiPathComputationTopologyConstraint.
        :type exclude_node: List[str]
        """

        self._exclude_node = exclude_node

    @property
    def include_topology(self) -> List[str]:
        """Gets the include_topology of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :return: The include_topology of this TapiPathComputationTopologyConstraint.
        :rtype: List[str]
        """
        return self._include_topology

    @include_topology.setter
    def include_topology(self, include_topology: List[str]):
        """Sets the include_topology of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :param include_topology: The include_topology of this TapiPathComputationTopologyConstraint.
        :type include_topology: List[str]
        """

        self._include_topology = include_topology

    @property
    def include_path(self) -> List[str]:
        """Gets the include_path of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :return: The include_path of this TapiPathComputationTopologyConstraint.
        :rtype: List[str]
        """
        return self._include_path

    @include_path.setter
    def include_path(self, include_path: List[str]):
        """Sets the include_path of this TapiPathComputationTopologyConstraint.

        none  # noqa: E501

        :param include_path: The include_path of this TapiPathComputationTopologyConstraint.
        :type include_path: List[str]
        """

        self._include_path = include_path
