# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_capacity import TapiCommonCapacity  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_local_class import TapiCommonLocalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_port_direction import TapiCommonPortDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_port_role import TapiCommonPortRole  # noqa: F401,E501
from tapi_server.models.tapi_common_service_interface_point_ref import TapiCommonServiceInterfacePointRef  # noqa: F401,E501
from tapi_server import util


class TapiPathComputationPathServiceEndPoint(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None, role: TapiCommonPortRole=None, service_interface_point: TapiCommonServiceInterfacePointRef=None, layer_protocol_name: TapiCommonLayerProtocolName=None, layer_protocol_qualifier: str=None, direction: TapiCommonPortDirection=None, capacity: TapiCommonCapacity=None):  # noqa: E501
        """TapiPathComputationPathServiceEndPoint - a model defined in Swagger

        :param name: The name of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :type local_id: str
        :param role: The role of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :type role: TapiCommonPortRole
        :param service_interface_point: The service_interface_point of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :type service_interface_point: TapiCommonServiceInterfacePointRef
        :param layer_protocol_name: The layer_protocol_name of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :type layer_protocol_name: TapiCommonLayerProtocolName
        :param layer_protocol_qualifier: The layer_protocol_qualifier of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :type layer_protocol_qualifier: str
        :param direction: The direction of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :type direction: TapiCommonPortDirection
        :param capacity: The capacity of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :type capacity: TapiCommonCapacity
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str,
            'role': TapiCommonPortRole,
            'service_interface_point': TapiCommonServiceInterfacePointRef,
            'layer_protocol_name': TapiCommonLayerProtocolName,
            'layer_protocol_qualifier': str,
            'direction': TapiCommonPortDirection,
            'capacity': TapiCommonCapacity
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id',
            'role': 'role',
            'service_interface_point': 'service-interface-point',
            'layer_protocol_name': 'layer-protocol-name',
            'layer_protocol_qualifier': 'layer-protocol-qualifier',
            'direction': 'direction',
            'capacity': 'capacity'
        }
        self._name = name
        self._local_id = local_id
        self._role = role
        self._service_interface_point = service_interface_point
        self._layer_protocol_name = layer_protocol_name
        self._layer_protocol_qualifier = layer_protocol_qualifier
        self._direction = direction
        self._capacity = capacity

    @classmethod
    def from_dict(cls, dikt) -> 'TapiPathComputationPathServiceEndPoint':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.path.computation.PathServiceEndPoint of this TapiPathComputationPathServiceEndPoint.  # noqa: E501
        :rtype: TapiPathComputationPathServiceEndPoint
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiPathComputationPathServiceEndPoint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiPathComputationPathServiceEndPoint.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiPathComputationPathServiceEndPoint.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiPathComputationPathServiceEndPoint.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiPathComputationPathServiceEndPoint.

        none  # noqa: E501

        :return: The local_id of this TapiPathComputationPathServiceEndPoint.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiPathComputationPathServiceEndPoint.

        none  # noqa: E501

        :param local_id: The local_id of this TapiPathComputationPathServiceEndPoint.
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def role(self) -> TapiCommonPortRole:
        """Gets the role of this TapiPathComputationPathServiceEndPoint.


        :return: The role of this TapiPathComputationPathServiceEndPoint.
        :rtype: TapiCommonPortRole
        """
        return self._role

    @role.setter
    def role(self, role: TapiCommonPortRole):
        """Sets the role of this TapiPathComputationPathServiceEndPoint.


        :param role: The role of this TapiPathComputationPathServiceEndPoint.
        :type role: TapiCommonPortRole
        """

        self._role = role

    @property
    def service_interface_point(self) -> TapiCommonServiceInterfacePointRef:
        """Gets the service_interface_point of this TapiPathComputationPathServiceEndPoint.


        :return: The service_interface_point of this TapiPathComputationPathServiceEndPoint.
        :rtype: TapiCommonServiceInterfacePointRef
        """
        return self._service_interface_point

    @service_interface_point.setter
    def service_interface_point(self, service_interface_point: TapiCommonServiceInterfacePointRef):
        """Sets the service_interface_point of this TapiPathComputationPathServiceEndPoint.


        :param service_interface_point: The service_interface_point of this TapiPathComputationPathServiceEndPoint.
        :type service_interface_point: TapiCommonServiceInterfacePointRef
        """

        self._service_interface_point = service_interface_point

    @property
    def layer_protocol_name(self) -> TapiCommonLayerProtocolName:
        """Gets the layer_protocol_name of this TapiPathComputationPathServiceEndPoint.


        :return: The layer_protocol_name of this TapiPathComputationPathServiceEndPoint.
        :rtype: TapiCommonLayerProtocolName
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: TapiCommonLayerProtocolName):
        """Sets the layer_protocol_name of this TapiPathComputationPathServiceEndPoint.


        :param layer_protocol_name: The layer_protocol_name of this TapiPathComputationPathServiceEndPoint.
        :type layer_protocol_name: TapiCommonLayerProtocolName
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def layer_protocol_qualifier(self) -> str:
        """Gets the layer_protocol_qualifier of this TapiPathComputationPathServiceEndPoint.

        none  # noqa: E501

        :return: The layer_protocol_qualifier of this TapiPathComputationPathServiceEndPoint.
        :rtype: str
        """
        return self._layer_protocol_qualifier

    @layer_protocol_qualifier.setter
    def layer_protocol_qualifier(self, layer_protocol_qualifier: str):
        """Sets the layer_protocol_qualifier of this TapiPathComputationPathServiceEndPoint.

        none  # noqa: E501

        :param layer_protocol_qualifier: The layer_protocol_qualifier of this TapiPathComputationPathServiceEndPoint.
        :type layer_protocol_qualifier: str
        """

        self._layer_protocol_qualifier = layer_protocol_qualifier

    @property
    def direction(self) -> TapiCommonPortDirection:
        """Gets the direction of this TapiPathComputationPathServiceEndPoint.


        :return: The direction of this TapiPathComputationPathServiceEndPoint.
        :rtype: TapiCommonPortDirection
        """
        return self._direction

    @direction.setter
    def direction(self, direction: TapiCommonPortDirection):
        """Sets the direction of this TapiPathComputationPathServiceEndPoint.


        :param direction: The direction of this TapiPathComputationPathServiceEndPoint.
        :type direction: TapiCommonPortDirection
        """

        self._direction = direction

    @property
    def capacity(self) -> TapiCommonCapacity:
        """Gets the capacity of this TapiPathComputationPathServiceEndPoint.


        :return: The capacity of this TapiPathComputationPathServiceEndPoint.
        :rtype: TapiCommonCapacity
        """
        return self._capacity

    @capacity.setter
    def capacity(self, capacity: TapiCommonCapacity):
        """Sets the capacity of this TapiPathComputationPathServiceEndPoint.


        :param capacity: The capacity of this TapiPathComputationPathServiceEndPoint.
        :type capacity: TapiCommonCapacity
        """

        self._capacity = capacity
