# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_forwarding_direction import TapiCommonForwardingDirection  # noqa: F401,E501
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_lifecycle_state import TapiCommonLifecycleState  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_operational_state import TapiCommonOperationalState  # noqa: F401,E501
from tapi_server.models.tapi_common_operational_state_pac import TapiCommonOperationalStatePac  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connection_end_point_ref import TapiConnectivityConnectionEndPointRef  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connection_ref import TapiConnectivityConnectionRef  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connection_spec_reference import TapiConnectivityConnectionSpecReference  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_route import TapiConnectivityRoute  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_switch_control import TapiConnectivitySwitchControl  # noqa: F401,E501
from tapi_server.models.tapi_topology_link_ref import TapiTopologyLinkRef  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityConnection(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, operational_state: TapiCommonOperationalState=None, lifecycle_state: TapiCommonLifecycleState=None, name: List[TapiCommonNameAndValue]=None, uuid: str=None, supported_client_link: List[TapiTopologyLinkRef]=None, lower_connection: List[TapiConnectivityConnectionRef]=None, switch_control: List[TapiConnectivitySwitchControl]=None, route: List[TapiConnectivityRoute]=None, connection_spec_reference: TapiConnectivityConnectionSpecReference=None, layer_protocol_name: TapiCommonLayerProtocolName=None, connection_end_point: List[TapiConnectivityConnectionEndPointRef]=None, direction: TapiCommonForwardingDirection=None):  # noqa: E501
        """TapiConnectivityConnection - a model defined in Swagger

        :param operational_state: The operational_state of this TapiConnectivityConnection.  # noqa: E501
        :type operational_state: TapiCommonOperationalState
        :param lifecycle_state: The lifecycle_state of this TapiConnectivityConnection.  # noqa: E501
        :type lifecycle_state: TapiCommonLifecycleState
        :param name: The name of this TapiConnectivityConnection.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiConnectivityConnection.  # noqa: E501
        :type uuid: str
        :param supported_client_link: The supported_client_link of this TapiConnectivityConnection.  # noqa: E501
        :type supported_client_link: List[TapiTopologyLinkRef]
        :param lower_connection: The lower_connection of this TapiConnectivityConnection.  # noqa: E501
        :type lower_connection: List[TapiConnectivityConnectionRef]
        :param switch_control: The switch_control of this TapiConnectivityConnection.  # noqa: E501
        :type switch_control: List[TapiConnectivitySwitchControl]
        :param route: The route of this TapiConnectivityConnection.  # noqa: E501
        :type route: List[TapiConnectivityRoute]
        :param connection_spec_reference: The connection_spec_reference of this TapiConnectivityConnection.  # noqa: E501
        :type connection_spec_reference: TapiConnectivityConnectionSpecReference
        :param layer_protocol_name: The layer_protocol_name of this TapiConnectivityConnection.  # noqa: E501
        :type layer_protocol_name: TapiCommonLayerProtocolName
        :param connection_end_point: The connection_end_point of this TapiConnectivityConnection.  # noqa: E501
        :type connection_end_point: List[TapiConnectivityConnectionEndPointRef]
        :param direction: The direction of this TapiConnectivityConnection.  # noqa: E501
        :type direction: TapiCommonForwardingDirection
        """
        self.swagger_types = {
            'operational_state': TapiCommonOperationalState,
            'lifecycle_state': TapiCommonLifecycleState,
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'supported_client_link': List[TapiTopologyLinkRef],
            'lower_connection': List[TapiConnectivityConnectionRef],
            'switch_control': List[TapiConnectivitySwitchControl],
            'route': List[TapiConnectivityRoute],
            'connection_spec_reference': TapiConnectivityConnectionSpecReference,
            'layer_protocol_name': TapiCommonLayerProtocolName,
            'connection_end_point': List[TapiConnectivityConnectionEndPointRef],
            'direction': TapiCommonForwardingDirection
        }

        self.attribute_map = {
            'operational_state': 'operational-state',
            'lifecycle_state': 'lifecycle-state',
            'name': 'name',
            'uuid': 'uuid',
            'supported_client_link': 'supported-client-link',
            'lower_connection': 'lower-connection',
            'switch_control': 'switch-control',
            'route': 'route',
            'connection_spec_reference': 'connection-spec-reference',
            'layer_protocol_name': 'layer-protocol-name',
            'connection_end_point': 'connection-end-point',
            'direction': 'direction'
        }
        self._operational_state = operational_state
        self._lifecycle_state = lifecycle_state
        self._name = name
        self._uuid = uuid
        self._supported_client_link = supported_client_link
        self._lower_connection = lower_connection
        self._switch_control = switch_control
        self._route = route
        self._connection_spec_reference = connection_spec_reference
        self._layer_protocol_name = layer_protocol_name
        self._connection_end_point = connection_end_point
        self._direction = direction

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityConnection':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.Connection of this TapiConnectivityConnection.  # noqa: E501
        :rtype: TapiConnectivityConnection
        """
        return util.deserialize_model(dikt, cls)

    @property
    def operational_state(self) -> TapiCommonOperationalState:
        """Gets the operational_state of this TapiConnectivityConnection.


        :return: The operational_state of this TapiConnectivityConnection.
        :rtype: TapiCommonOperationalState
        """
        return self._operational_state

    @operational_state.setter
    def operational_state(self, operational_state: TapiCommonOperationalState):
        """Sets the operational_state of this TapiConnectivityConnection.


        :param operational_state: The operational_state of this TapiConnectivityConnection.
        :type operational_state: TapiCommonOperationalState
        """

        self._operational_state = operational_state

    @property
    def lifecycle_state(self) -> TapiCommonLifecycleState:
        """Gets the lifecycle_state of this TapiConnectivityConnection.


        :return: The lifecycle_state of this TapiConnectivityConnection.
        :rtype: TapiCommonLifecycleState
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state: TapiCommonLifecycleState):
        """Sets the lifecycle_state of this TapiConnectivityConnection.


        :param lifecycle_state: The lifecycle_state of this TapiConnectivityConnection.
        :type lifecycle_state: TapiCommonLifecycleState
        """

        self._lifecycle_state = lifecycle_state

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiConnectivityConnection.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiConnectivityConnection.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiConnectivityConnection.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiConnectivityConnection.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiConnectivityConnection.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiConnectivityConnection.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiConnectivityConnection.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiConnectivityConnection.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def supported_client_link(self) -> List[TapiTopologyLinkRef]:
        """Gets the supported_client_link of this TapiConnectivityConnection.

        none  # noqa: E501

        :return: The supported_client_link of this TapiConnectivityConnection.
        :rtype: List[TapiTopologyLinkRef]
        """
        return self._supported_client_link

    @supported_client_link.setter
    def supported_client_link(self, supported_client_link: List[TapiTopologyLinkRef]):
        """Sets the supported_client_link of this TapiConnectivityConnection.

        none  # noqa: E501

        :param supported_client_link: The supported_client_link of this TapiConnectivityConnection.
        :type supported_client_link: List[TapiTopologyLinkRef]
        """

        self._supported_client_link = supported_client_link

    @property
    def lower_connection(self) -> List[TapiConnectivityConnectionRef]:
        """Gets the lower_connection of this TapiConnectivityConnection.

        An Connection object supports a recursive aggregation relationship such that the internal construction of an Connection can be exposed as multiple lower level Connection objects (partitioning).                  Aggregation is used as for the Node/Topology  to allow changes in hierarchy.                   Connection aggregation reflects Node/Topology aggregation.                   The FC represents a Cross-Connection in an NE. The Cross-Connection in an NE is not necessarily the lowest level of FC partitioning.  # noqa: E501

        :return: The lower_connection of this TapiConnectivityConnection.
        :rtype: List[TapiConnectivityConnectionRef]
        """
        return self._lower_connection

    @lower_connection.setter
    def lower_connection(self, lower_connection: List[TapiConnectivityConnectionRef]):
        """Sets the lower_connection of this TapiConnectivityConnection.

        An Connection object supports a recursive aggregation relationship such that the internal construction of an Connection can be exposed as multiple lower level Connection objects (partitioning).                  Aggregation is used as for the Node/Topology  to allow changes in hierarchy.                   Connection aggregation reflects Node/Topology aggregation.                   The FC represents a Cross-Connection in an NE. The Cross-Connection in an NE is not necessarily the lowest level of FC partitioning.  # noqa: E501

        :param lower_connection: The lower_connection of this TapiConnectivityConnection.
        :type lower_connection: List[TapiConnectivityConnectionRef]
        """

        self._lower_connection = lower_connection

    @property
    def switch_control(self) -> List[TapiConnectivitySwitchControl]:
        """Gets the switch_control of this TapiConnectivityConnection.

        none  # noqa: E501

        :return: The switch_control of this TapiConnectivityConnection.
        :rtype: List[TapiConnectivitySwitchControl]
        """
        return self._switch_control

    @switch_control.setter
    def switch_control(self, switch_control: List[TapiConnectivitySwitchControl]):
        """Sets the switch_control of this TapiConnectivityConnection.

        none  # noqa: E501

        :param switch_control: The switch_control of this TapiConnectivityConnection.
        :type switch_control: List[TapiConnectivitySwitchControl]
        """

        self._switch_control = switch_control

    @property
    def route(self) -> List[TapiConnectivityRoute]:
        """Gets the route of this TapiConnectivityConnection.

        none  # noqa: E501

        :return: The route of this TapiConnectivityConnection.
        :rtype: List[TapiConnectivityRoute]
        """
        return self._route

    @route.setter
    def route(self, route: List[TapiConnectivityRoute]):
        """Sets the route of this TapiConnectivityConnection.

        none  # noqa: E501

        :param route: The route of this TapiConnectivityConnection.
        :type route: List[TapiConnectivityRoute]
        """

        self._route = route

    @property
    def connection_spec_reference(self) -> TapiConnectivityConnectionSpecReference:
        """Gets the connection_spec_reference of this TapiConnectivityConnection.


        :return: The connection_spec_reference of this TapiConnectivityConnection.
        :rtype: TapiConnectivityConnectionSpecReference
        """
        return self._connection_spec_reference

    @connection_spec_reference.setter
    def connection_spec_reference(self, connection_spec_reference: TapiConnectivityConnectionSpecReference):
        """Sets the connection_spec_reference of this TapiConnectivityConnection.


        :param connection_spec_reference: The connection_spec_reference of this TapiConnectivityConnection.
        :type connection_spec_reference: TapiConnectivityConnectionSpecReference
        """

        self._connection_spec_reference = connection_spec_reference

    @property
    def layer_protocol_name(self) -> TapiCommonLayerProtocolName:
        """Gets the layer_protocol_name of this TapiConnectivityConnection.


        :return: The layer_protocol_name of this TapiConnectivityConnection.
        :rtype: TapiCommonLayerProtocolName
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: TapiCommonLayerProtocolName):
        """Sets the layer_protocol_name of this TapiConnectivityConnection.


        :param layer_protocol_name: The layer_protocol_name of this TapiConnectivityConnection.
        :type layer_protocol_name: TapiCommonLayerProtocolName
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def connection_end_point(self) -> List[TapiConnectivityConnectionEndPointRef]:
        """Gets the connection_end_point of this TapiConnectivityConnection.

        none  # noqa: E501

        :return: The connection_end_point of this TapiConnectivityConnection.
        :rtype: List[TapiConnectivityConnectionEndPointRef]
        """
        return self._connection_end_point

    @connection_end_point.setter
    def connection_end_point(self, connection_end_point: List[TapiConnectivityConnectionEndPointRef]):
        """Sets the connection_end_point of this TapiConnectivityConnection.

        none  # noqa: E501

        :param connection_end_point: The connection_end_point of this TapiConnectivityConnection.
        :type connection_end_point: List[TapiConnectivityConnectionEndPointRef]
        """

        self._connection_end_point = connection_end_point

    @property
    def direction(self) -> TapiCommonForwardingDirection:
        """Gets the direction of this TapiConnectivityConnection.


        :return: The direction of this TapiConnectivityConnection.
        :rtype: TapiCommonForwardingDirection
        """
        return self._direction

    @direction.setter
    def direction(self, direction: TapiCommonForwardingDirection):
        """Sets the direction of this TapiConnectivityConnection.


        :param direction: The direction of this TapiConnectivityConnection.
        :type direction: TapiCommonForwardingDirection
        """

        self._direction = direction
