# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_connectivity_connection_spec_reference import TapiConnectivityConnectionSpecReference  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityCepRole(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, role_name: str=None, connection_spec_reference: TapiConnectivityConnectionSpecReference=None):  # noqa: E501
        """TapiConnectivityCepRole - a model defined in Swagger

        :param role_name: The role_name of this TapiConnectivityCepRole.  # noqa: E501
        :type role_name: str
        :param connection_spec_reference: The connection_spec_reference of this TapiConnectivityCepRole.  # noqa: E501
        :type connection_spec_reference: TapiConnectivityConnectionSpecReference
        """
        self.swagger_types = {
            'role_name': str,
            'connection_spec_reference': TapiConnectivityConnectionSpecReference
        }

        self.attribute_map = {
            'role_name': 'role-name',
            'connection_spec_reference': 'connection-spec-reference'
        }
        self._role_name = role_name
        self._connection_spec_reference = connection_spec_reference

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityCepRole':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.CepRole of this TapiConnectivityCepRole.  # noqa: E501
        :rtype: TapiConnectivityCepRole
        """
        return util.deserialize_model(dikt, cls)

    @property
    def role_name(self) -> str:
        """Gets the role_name of this TapiConnectivityCepRole.

        The name of the cep role in the context of the referenced spec.  # noqa: E501

        :return: The role_name of this TapiConnectivityCepRole.
        :rtype: str
        """
        return self._role_name

    @role_name.setter
    def role_name(self, role_name: str):
        """Sets the role_name of this TapiConnectivityCepRole.

        The name of the cep role in the context of the referenced spec.  # noqa: E501

        :param role_name: The role_name of this TapiConnectivityCepRole.
        :type role_name: str
        """

        self._role_name = role_name

    @property
    def connection_spec_reference(self) -> TapiConnectivityConnectionSpecReference:
        """Gets the connection_spec_reference of this TapiConnectivityCepRole.


        :return: The connection_spec_reference of this TapiConnectivityCepRole.
        :rtype: TapiConnectivityConnectionSpecReference
        """
        return self._connection_spec_reference

    @connection_spec_reference.setter
    def connection_spec_reference(self, connection_spec_reference: TapiConnectivityConnectionSpecReference):
        """Sets the connection_spec_reference of this TapiConnectivityCepRole.


        :param connection_spec_reference: The connection_spec_reference of this TapiConnectivityCepRole.
        :type connection_spec_reference: TapiConnectivityConnectionSpecReference
        """

        self._connection_spec_reference = connection_spec_reference
