# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_service_interface_point import TapiCommonServiceInterfacePoint  # noqa: F401,E501
from tapi_server.models.tapi_common_tapi_context import TapiCommonTapiContext  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connectivity_context import TapiConnectivityConnectivityContext  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_context_augmentation3 import TapiConnectivityContextAugmentation3  # noqa: F401,E501
from tapi_server.models.tapi_notification_context_augmentation1 import TapiNotificationContextAugmentation1  # noqa: F401,E501
from tapi_server.models.tapi_notification_notification_context import TapiNotificationNotificationContext  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_context_augmentation2 import TapiPathComputationContextAugmentation2  # noqa: F401,E501
from tapi_server.models.tapi_path_computation_path_computation_context import TapiPathComputationPathComputationContext  # noqa: F401,E501
from tapi_server.models.tapi_topology_context_augmentation4 import TapiTopologyContextAugmentation4  # noqa: F401,E501
from tapi_server.models.tapi_topology_topology_context import TapiTopologyTopologyContext  # noqa: F401,E501
from tapi_server import util


class TapiCommonContext(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, connectivity_context: TapiConnectivityConnectivityContext=None, notification_context: TapiNotificationNotificationContext=None, path_computation_context: TapiPathComputationPathComputationContext=None, topology_context: TapiTopologyTopologyContext=None, service_interface_point: List[TapiCommonServiceInterfacePoint]=None):  # noqa: E501
        """TapiCommonContext - a model defined in Swagger

        :param connectivity_context: The connectivity_context of this TapiCommonContext.  # noqa: E501
        :type connectivity_context: TapiConnectivityConnectivityContext
        :param notification_context: The notification_context of this TapiCommonContext.  # noqa: E501
        :type notification_context: TapiNotificationNotificationContext
        :param path_computation_context: The path_computation_context of this TapiCommonContext.  # noqa: E501
        :type path_computation_context: TapiPathComputationPathComputationContext
        :param topology_context: The topology_context of this TapiCommonContext.  # noqa: E501
        :type topology_context: TapiTopologyTopologyContext
        :param service_interface_point: The service_interface_point of this TapiCommonContext.  # noqa: E501
        :type service_interface_point: List[TapiCommonServiceInterfacePoint]
        """
        self.swagger_types = {
            'connectivity_context': TapiConnectivityConnectivityContext,
            'notification_context': TapiNotificationNotificationContext,
            'path_computation_context': TapiPathComputationPathComputationContext,
            'topology_context': TapiTopologyTopologyContext,
            'service_interface_point': List[TapiCommonServiceInterfacePoint]
        }

        self.attribute_map = {
            'connectivity_context': 'connectivity-context',
            'notification_context': 'notification-context',
            'path_computation_context': 'path-computation-context',
            'topology_context': 'topology-context',
            'service_interface_point': 'service-interface-point'
        }
        self._connectivity_context = connectivity_context
        self._notification_context = notification_context
        self._path_computation_context = path_computation_context
        self._topology_context = topology_context
        self._service_interface_point = service_interface_point

    @classmethod
    def from_dict(cls, dikt) -> 'TapiCommonContext':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.common.Context of this TapiCommonContext.  # noqa: E501
        :rtype: TapiCommonContext
        """
        return util.deserialize_model(dikt, cls)

    @property
    def connectivity_context(self) -> TapiConnectivityConnectivityContext:
        """Gets the connectivity_context of this TapiCommonContext.


        :return: The connectivity_context of this TapiCommonContext.
        :rtype: TapiConnectivityConnectivityContext
        """
        return self._connectivity_context

    @connectivity_context.setter
    def connectivity_context(self, connectivity_context: TapiConnectivityConnectivityContext):
        """Sets the connectivity_context of this TapiCommonContext.


        :param connectivity_context: The connectivity_context of this TapiCommonContext.
        :type connectivity_context: TapiConnectivityConnectivityContext
        """

        self._connectivity_context = connectivity_context

    @property
    def notification_context(self) -> TapiNotificationNotificationContext:
        """Gets the notification_context of this TapiCommonContext.


        :return: The notification_context of this TapiCommonContext.
        :rtype: TapiNotificationNotificationContext
        """
        return self._notification_context

    @notification_context.setter
    def notification_context(self, notification_context: TapiNotificationNotificationContext):
        """Sets the notification_context of this TapiCommonContext.


        :param notification_context: The notification_context of this TapiCommonContext.
        :type notification_context: TapiNotificationNotificationContext
        """

        self._notification_context = notification_context

    @property
    def path_computation_context(self) -> TapiPathComputationPathComputationContext:
        """Gets the path_computation_context of this TapiCommonContext.


        :return: The path_computation_context of this TapiCommonContext.
        :rtype: TapiPathComputationPathComputationContext
        """
        return self._path_computation_context

    @path_computation_context.setter
    def path_computation_context(self, path_computation_context: TapiPathComputationPathComputationContext):
        """Sets the path_computation_context of this TapiCommonContext.


        :param path_computation_context: The path_computation_context of this TapiCommonContext.
        :type path_computation_context: TapiPathComputationPathComputationContext
        """

        self._path_computation_context = path_computation_context

    @property
    def topology_context(self) -> TapiTopologyTopologyContext:
        """Gets the topology_context of this TapiCommonContext.


        :return: The topology_context of this TapiCommonContext.
        :rtype: TapiTopologyTopologyContext
        """
        return self._topology_context

    @topology_context.setter
    def topology_context(self, topology_context: TapiTopologyTopologyContext):
        """Sets the topology_context of this TapiCommonContext.


        :param topology_context: The topology_context of this TapiCommonContext.
        :type topology_context: TapiTopologyTopologyContext
        """

        self._topology_context = topology_context

    @property
    def service_interface_point(self) -> List[TapiCommonServiceInterfacePoint]:
        """Gets the service_interface_point of this TapiCommonContext.

        none  # noqa: E501

        :return: The service_interface_point of this TapiCommonContext.
        :rtype: List[TapiCommonServiceInterfacePoint]
        """
        return self._service_interface_point

    @service_interface_point.setter
    def service_interface_point(self, service_interface_point: List[TapiCommonServiceInterfacePoint]):
        """Sets the service_interface_point of this TapiCommonContext.

        none  # noqa: E501

        :param service_interface_point: The service_interface_point of this TapiCommonContext.
        :type service_interface_point: List[TapiCommonServiceInterfacePoint]
        """

        self._service_interface_point = service_interface_point
