# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_admin_state_pac import TapiCommonAdminStatePac  # noqa: F401,E501
from tapi_server.models.tapi_common_administrative_state import TapiCommonAdministrativeState  # noqa: F401,E501
from tapi_server.models.tapi_common_capacity import TapiCommonCapacity  # noqa: F401,E501
from tapi_server.models.tapi_common_capacity_pac import TapiCommonCapacityPac  # noqa: F401,E501
from tapi_server.models.tapi_common_global_class import TapiCommonGlobalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_layer_protocol_name import TapiCommonLayerProtocolName  # noqa: F401,E501
from tapi_server.models.tapi_common_lifecycle_state import TapiCommonLifecycleState  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_common_operational_state import TapiCommonOperationalState  # noqa: F401,E501
from tapi_server.models.tapi_topology_cost_characteristic import TapiTopologyCostCharacteristic  # noqa: F401,E501
from tapi_server.models.tapi_topology_latency_characteristic import TapiTopologyLatencyCharacteristic  # noqa: F401,E501
from tapi_server.models.tapi_topology_node_edge_point import TapiTopologyNodeEdgePoint  # noqa: F401,E501
from tapi_server.models.tapi_topology_node_edge_point_ref import TapiTopologyNodeEdgePointRef  # noqa: F401,E501
from tapi_server.models.tapi_topology_node_rule_group import TapiTopologyNodeRuleGroup  # noqa: F401,E501
from tapi_server.models.tapi_topology_topology_ref import TapiTopologyTopologyRef  # noqa: F401,E501
from tapi_server.models.tapi_topology_transfer_cost_pac import TapiTopologyTransferCostPac  # noqa: F401,E501
from tapi_server.models.tapi_topology_transfer_integrity_pac import TapiTopologyTransferIntegrityPac  # noqa: F401,E501
from tapi_server.models.tapi_topology_transfer_timing_pac import TapiTopologyTransferTimingPac  # noqa: F401,E501
from tapi_server import util


class TapiTopologyNode(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, available_capacity: TapiCommonCapacity=None, total_potential_capacity: TapiCommonCapacity=None, name: List[TapiCommonNameAndValue]=None, uuid: str=None, cost_characteristic: List[TapiTopologyCostCharacteristic]=None, error_characteristic: str=None, unavailable_time_characteristic: str=None, server_integrity_process_characteristic: str=None, delivery_order_characteristic: str=None, repeat_delivery_characteristic: str=None, loss_characteristic: str=None, latency_characteristic: List[TapiTopologyLatencyCharacteristic]=None, operational_state: TapiCommonOperationalState=None, lifecycle_state: TapiCommonLifecycleState=None, administrative_state: TapiCommonAdministrativeState=None, layer_protocol_name: List[TapiCommonLayerProtocolName]=None, encap_topology: TapiTopologyTopologyRef=None, owned_node_edge_point: List[TapiTopologyNodeEdgePoint]=None, node_rule_group: List[TapiTopologyNodeRuleGroup]=None, aggregated_node_edge_point: List[TapiTopologyNodeEdgePointRef]=None):  # noqa: E501
        """TapiTopologyNode - a model defined in Swagger

        :param available_capacity: The available_capacity of this TapiTopologyNode.  # noqa: E501
        :type available_capacity: TapiCommonCapacity
        :param total_potential_capacity: The total_potential_capacity of this TapiTopologyNode.  # noqa: E501
        :type total_potential_capacity: TapiCommonCapacity
        :param name: The name of this TapiTopologyNode.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param uuid: The uuid of this TapiTopologyNode.  # noqa: E501
        :type uuid: str
        :param cost_characteristic: The cost_characteristic of this TapiTopologyNode.  # noqa: E501
        :type cost_characteristic: List[TapiTopologyCostCharacteristic]
        :param error_characteristic: The error_characteristic of this TapiTopologyNode.  # noqa: E501
        :type error_characteristic: str
        :param unavailable_time_characteristic: The unavailable_time_characteristic of this TapiTopologyNode.  # noqa: E501
        :type unavailable_time_characteristic: str
        :param server_integrity_process_characteristic: The server_integrity_process_characteristic of this TapiTopologyNode.  # noqa: E501
        :type server_integrity_process_characteristic: str
        :param delivery_order_characteristic: The delivery_order_characteristic of this TapiTopologyNode.  # noqa: E501
        :type delivery_order_characteristic: str
        :param repeat_delivery_characteristic: The repeat_delivery_characteristic of this TapiTopologyNode.  # noqa: E501
        :type repeat_delivery_characteristic: str
        :param loss_characteristic: The loss_characteristic of this TapiTopologyNode.  # noqa: E501
        :type loss_characteristic: str
        :param latency_characteristic: The latency_characteristic of this TapiTopologyNode.  # noqa: E501
        :type latency_characteristic: List[TapiTopologyLatencyCharacteristic]
        :param operational_state: The operational_state of this TapiTopologyNode.  # noqa: E501
        :type operational_state: TapiCommonOperationalState
        :param lifecycle_state: The lifecycle_state of this TapiTopologyNode.  # noqa: E501
        :type lifecycle_state: TapiCommonLifecycleState
        :param administrative_state: The administrative_state of this TapiTopologyNode.  # noqa: E501
        :type administrative_state: TapiCommonAdministrativeState
        :param layer_protocol_name: The layer_protocol_name of this TapiTopologyNode.  # noqa: E501
        :type layer_protocol_name: List[TapiCommonLayerProtocolName]
        :param encap_topology: The encap_topology of this TapiTopologyNode.  # noqa: E501
        :type encap_topology: TapiTopologyTopologyRef
        :param owned_node_edge_point: The owned_node_edge_point of this TapiTopologyNode.  # noqa: E501
        :type owned_node_edge_point: List[TapiTopologyNodeEdgePoint]
        :param node_rule_group: The node_rule_group of this TapiTopologyNode.  # noqa: E501
        :type node_rule_group: List[TapiTopologyNodeRuleGroup]
        :param aggregated_node_edge_point: The aggregated_node_edge_point of this TapiTopologyNode.  # noqa: E501
        :type aggregated_node_edge_point: List[TapiTopologyNodeEdgePointRef]
        """
        self.swagger_types = {
            'available_capacity': TapiCommonCapacity,
            'total_potential_capacity': TapiCommonCapacity,
            'name': List[TapiCommonNameAndValue],
            'uuid': str,
            'cost_characteristic': List[TapiTopologyCostCharacteristic],
            'error_characteristic': str,
            'unavailable_time_characteristic': str,
            'server_integrity_process_characteristic': str,
            'delivery_order_characteristic': str,
            'repeat_delivery_characteristic': str,
            'loss_characteristic': str,
            'latency_characteristic': List[TapiTopologyLatencyCharacteristic],
            'operational_state': TapiCommonOperationalState,
            'lifecycle_state': TapiCommonLifecycleState,
            'administrative_state': TapiCommonAdministrativeState,
            'layer_protocol_name': List[TapiCommonLayerProtocolName],
            'encap_topology': TapiTopologyTopologyRef,
            'owned_node_edge_point': List[TapiTopologyNodeEdgePoint],
            'node_rule_group': List[TapiTopologyNodeRuleGroup],
            'aggregated_node_edge_point': List[TapiTopologyNodeEdgePointRef]
        }

        self.attribute_map = {
            'available_capacity': 'available-capacity',
            'total_potential_capacity': 'total-potential-capacity',
            'name': 'name',
            'uuid': 'uuid',
            'cost_characteristic': 'cost-characteristic',
            'error_characteristic': 'error-characteristic',
            'unavailable_time_characteristic': 'unavailable-time-characteristic',
            'server_integrity_process_characteristic': 'server-integrity-process-characteristic',
            'delivery_order_characteristic': 'delivery-order-characteristic',
            'repeat_delivery_characteristic': 'repeat-delivery-characteristic',
            'loss_characteristic': 'loss-characteristic',
            'latency_characteristic': 'latency-characteristic',
            'operational_state': 'operational-state',
            'lifecycle_state': 'lifecycle-state',
            'administrative_state': 'administrative-state',
            'layer_protocol_name': 'layer-protocol-name',
            'encap_topology': 'encap-topology',
            'owned_node_edge_point': 'owned-node-edge-point',
            'node_rule_group': 'node-rule-group',
            'aggregated_node_edge_point': 'aggregated-node-edge-point'
        }
        self._available_capacity = available_capacity
        self._total_potential_capacity = total_potential_capacity
        self._name = name
        self._uuid = uuid
        self._cost_characteristic = cost_characteristic
        self._error_characteristic = error_characteristic
        self._unavailable_time_characteristic = unavailable_time_characteristic
        self._server_integrity_process_characteristic = server_integrity_process_characteristic
        self._delivery_order_characteristic = delivery_order_characteristic
        self._repeat_delivery_characteristic = repeat_delivery_characteristic
        self._loss_characteristic = loss_characteristic
        self._latency_characteristic = latency_characteristic
        self._operational_state = operational_state
        self._lifecycle_state = lifecycle_state
        self._administrative_state = administrative_state
        self._layer_protocol_name = layer_protocol_name
        self._encap_topology = encap_topology
        self._owned_node_edge_point = owned_node_edge_point
        self._node_rule_group = node_rule_group
        self._aggregated_node_edge_point = aggregated_node_edge_point

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyNode':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.Node of this TapiTopologyNode.  # noqa: E501
        :rtype: TapiTopologyNode
        """
        return util.deserialize_model(dikt, cls)

    @property
    def available_capacity(self) -> TapiCommonCapacity:
        """Gets the available_capacity of this TapiTopologyNode.


        :return: The available_capacity of this TapiTopologyNode.
        :rtype: TapiCommonCapacity
        """
        return self._available_capacity

    @available_capacity.setter
    def available_capacity(self, available_capacity: TapiCommonCapacity):
        """Sets the available_capacity of this TapiTopologyNode.


        :param available_capacity: The available_capacity of this TapiTopologyNode.
        :type available_capacity: TapiCommonCapacity
        """

        self._available_capacity = available_capacity

    @property
    def total_potential_capacity(self) -> TapiCommonCapacity:
        """Gets the total_potential_capacity of this TapiTopologyNode.


        :return: The total_potential_capacity of this TapiTopologyNode.
        :rtype: TapiCommonCapacity
        """
        return self._total_potential_capacity

    @total_potential_capacity.setter
    def total_potential_capacity(self, total_potential_capacity: TapiCommonCapacity):
        """Sets the total_potential_capacity of this TapiTopologyNode.


        :param total_potential_capacity: The total_potential_capacity of this TapiTopologyNode.
        :type total_potential_capacity: TapiCommonCapacity
        """

        self._total_potential_capacity = total_potential_capacity

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiTopologyNode.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiTopologyNode.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiTopologyNode.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiTopologyNode.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def uuid(self) -> str:
        """Gets the uuid of this TapiTopologyNode.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :return: The uuid of this TapiTopologyNode.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid: str):
        """Sets the uuid of this TapiTopologyNode.

        UUID: An identifier that is universally unique within an identifier space, where the identifier space is itself globally unique, and immutable. An UUID carries no semantics with respect to the purpose or state of the entity.                  UUID here uses string representation as defined in RFC 4122.  The canonical representation uses lowercase characters.                  Pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-' + '[0-9a-fA-F]{4}-[0-9a-fA-F]{12}                   Example of a UUID in string representation: f81d4fae-7dec-11d0-a765-00a0c91e6bf6  # noqa: E501

        :param uuid: The uuid of this TapiTopologyNode.
        :type uuid: str
        """

        self._uuid = uuid

    @property
    def cost_characteristic(self) -> List[TapiTopologyCostCharacteristic]:
        """Gets the cost_characteristic of this TapiTopologyNode.

        The list of costs where each cost relates to some aspect of the TopologicalEntity.  # noqa: E501

        :return: The cost_characteristic of this TapiTopologyNode.
        :rtype: List[TapiTopologyCostCharacteristic]
        """
        return self._cost_characteristic

    @cost_characteristic.setter
    def cost_characteristic(self, cost_characteristic: List[TapiTopologyCostCharacteristic]):
        """Sets the cost_characteristic of this TapiTopologyNode.

        The list of costs where each cost relates to some aspect of the TopologicalEntity.  # noqa: E501

        :param cost_characteristic: The cost_characteristic of this TapiTopologyNode.
        :type cost_characteristic: List[TapiTopologyCostCharacteristic]
        """

        self._cost_characteristic = cost_characteristic

    @property
    def error_characteristic(self) -> str:
        """Gets the error_characteristic of this TapiTopologyNode.

        Describes the degree to which the signal propagated can be errored.                  Applies to TDM systems as the errored signal will be propagated and not packet as errored packets will be discarded.  # noqa: E501

        :return: The error_characteristic of this TapiTopologyNode.
        :rtype: str
        """
        return self._error_characteristic

    @error_characteristic.setter
    def error_characteristic(self, error_characteristic: str):
        """Sets the error_characteristic of this TapiTopologyNode.

        Describes the degree to which the signal propagated can be errored.                  Applies to TDM systems as the errored signal will be propagated and not packet as errored packets will be discarded.  # noqa: E501

        :param error_characteristic: The error_characteristic of this TapiTopologyNode.
        :type error_characteristic: str
        """

        self._error_characteristic = error_characteristic

    @property
    def unavailable_time_characteristic(self) -> str:
        """Gets the unavailable_time_characteristic of this TapiTopologyNode.

        Describes the duration for which there may be no valid signal propagated.  # noqa: E501

        :return: The unavailable_time_characteristic of this TapiTopologyNode.
        :rtype: str
        """
        return self._unavailable_time_characteristic

    @unavailable_time_characteristic.setter
    def unavailable_time_characteristic(self, unavailable_time_characteristic: str):
        """Sets the unavailable_time_characteristic of this TapiTopologyNode.

        Describes the duration for which there may be no valid signal propagated.  # noqa: E501

        :param unavailable_time_characteristic: The unavailable_time_characteristic of this TapiTopologyNode.
        :type unavailable_time_characteristic: str
        """

        self._unavailable_time_characteristic = unavailable_time_characteristic

    @property
    def server_integrity_process_characteristic(self) -> str:
        """Gets the server_integrity_process_characteristic of this TapiTopologyNode.

        Describes the effect of any server integrity enhancement process on the characteristics of the TopologicalEntity.  # noqa: E501

        :return: The server_integrity_process_characteristic of this TapiTopologyNode.
        :rtype: str
        """
        return self._server_integrity_process_characteristic

    @server_integrity_process_characteristic.setter
    def server_integrity_process_characteristic(self, server_integrity_process_characteristic: str):
        """Sets the server_integrity_process_characteristic of this TapiTopologyNode.

        Describes the effect of any server integrity enhancement process on the characteristics of the TopologicalEntity.  # noqa: E501

        :param server_integrity_process_characteristic: The server_integrity_process_characteristic of this TapiTopologyNode.
        :type server_integrity_process_characteristic: str
        """

        self._server_integrity_process_characteristic = server_integrity_process_characteristic

    @property
    def delivery_order_characteristic(self) -> str:
        """Gets the delivery_order_characteristic of this TapiTopologyNode.

        Describes the degree to which packets will be delivered out of sequence.                  Does not apply to TDM as the TDM protocols maintain strict order.  # noqa: E501

        :return: The delivery_order_characteristic of this TapiTopologyNode.
        :rtype: str
        """
        return self._delivery_order_characteristic

    @delivery_order_characteristic.setter
    def delivery_order_characteristic(self, delivery_order_characteristic: str):
        """Sets the delivery_order_characteristic of this TapiTopologyNode.

        Describes the degree to which packets will be delivered out of sequence.                  Does not apply to TDM as the TDM protocols maintain strict order.  # noqa: E501

        :param delivery_order_characteristic: The delivery_order_characteristic of this TapiTopologyNode.
        :type delivery_order_characteristic: str
        """

        self._delivery_order_characteristic = delivery_order_characteristic

    @property
    def repeat_delivery_characteristic(self) -> str:
        """Gets the repeat_delivery_characteristic of this TapiTopologyNode.

        Primarily applies to packet systems where a packet may be delivered more than once (in fault recovery for example).                  It can also apply to TDM where several frames may be received twice due to switching in a system with a large differential propagation delay.  # noqa: E501

        :return: The repeat_delivery_characteristic of this TapiTopologyNode.
        :rtype: str
        """
        return self._repeat_delivery_characteristic

    @repeat_delivery_characteristic.setter
    def repeat_delivery_characteristic(self, repeat_delivery_characteristic: str):
        """Sets the repeat_delivery_characteristic of this TapiTopologyNode.

        Primarily applies to packet systems where a packet may be delivered more than once (in fault recovery for example).                  It can also apply to TDM where several frames may be received twice due to switching in a system with a large differential propagation delay.  # noqa: E501

        :param repeat_delivery_characteristic: The repeat_delivery_characteristic of this TapiTopologyNode.
        :type repeat_delivery_characteristic: str
        """

        self._repeat_delivery_characteristic = repeat_delivery_characteristic

    @property
    def loss_characteristic(self) -> str:
        """Gets the loss_characteristic of this TapiTopologyNode.

        Describes the acceptable characteristic of lost packets where loss may result from discard due to errors or overflow.                  Applies to packet systems and not TDM (as for TDM errored signals are propagated unless grossly errored and overflow/underflow turns into timing slips).  # noqa: E501

        :return: The loss_characteristic of this TapiTopologyNode.
        :rtype: str
        """
        return self._loss_characteristic

    @loss_characteristic.setter
    def loss_characteristic(self, loss_characteristic: str):
        """Sets the loss_characteristic of this TapiTopologyNode.

        Describes the acceptable characteristic of lost packets where loss may result from discard due to errors or overflow.                  Applies to packet systems and not TDM (as for TDM errored signals are propagated unless grossly errored and overflow/underflow turns into timing slips).  # noqa: E501

        :param loss_characteristic: The loss_characteristic of this TapiTopologyNode.
        :type loss_characteristic: str
        """

        self._loss_characteristic = loss_characteristic

    @property
    def latency_characteristic(self) -> List[TapiTopologyLatencyCharacteristic]:
        """Gets the latency_characteristic of this TapiTopologyNode.

        The effect on the latency of a queuing process. This only has significant effect for packet based systems and has a complex characteristic.  # noqa: E501

        :return: The latency_characteristic of this TapiTopologyNode.
        :rtype: List[TapiTopologyLatencyCharacteristic]
        """
        return self._latency_characteristic

    @latency_characteristic.setter
    def latency_characteristic(self, latency_characteristic: List[TapiTopologyLatencyCharacteristic]):
        """Sets the latency_characteristic of this TapiTopologyNode.

        The effect on the latency of a queuing process. This only has significant effect for packet based systems and has a complex characteristic.  # noqa: E501

        :param latency_characteristic: The latency_characteristic of this TapiTopologyNode.
        :type latency_characteristic: List[TapiTopologyLatencyCharacteristic]
        """

        self._latency_characteristic = latency_characteristic

    @property
    def operational_state(self) -> TapiCommonOperationalState:
        """Gets the operational_state of this TapiTopologyNode.


        :return: The operational_state of this TapiTopologyNode.
        :rtype: TapiCommonOperationalState
        """
        return self._operational_state

    @operational_state.setter
    def operational_state(self, operational_state: TapiCommonOperationalState):
        """Sets the operational_state of this TapiTopologyNode.


        :param operational_state: The operational_state of this TapiTopologyNode.
        :type operational_state: TapiCommonOperationalState
        """

        self._operational_state = operational_state

    @property
    def lifecycle_state(self) -> TapiCommonLifecycleState:
        """Gets the lifecycle_state of this TapiTopologyNode.


        :return: The lifecycle_state of this TapiTopologyNode.
        :rtype: TapiCommonLifecycleState
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state: TapiCommonLifecycleState):
        """Sets the lifecycle_state of this TapiTopologyNode.


        :param lifecycle_state: The lifecycle_state of this TapiTopologyNode.
        :type lifecycle_state: TapiCommonLifecycleState
        """

        self._lifecycle_state = lifecycle_state

    @property
    def administrative_state(self) -> TapiCommonAdministrativeState:
        """Gets the administrative_state of this TapiTopologyNode.


        :return: The administrative_state of this TapiTopologyNode.
        :rtype: TapiCommonAdministrativeState
        """
        return self._administrative_state

    @administrative_state.setter
    def administrative_state(self, administrative_state: TapiCommonAdministrativeState):
        """Sets the administrative_state of this TapiTopologyNode.


        :param administrative_state: The administrative_state of this TapiTopologyNode.
        :type administrative_state: TapiCommonAdministrativeState
        """

        self._administrative_state = administrative_state

    @property
    def layer_protocol_name(self) -> List[TapiCommonLayerProtocolName]:
        """Gets the layer_protocol_name of this TapiTopologyNode.

        none  # noqa: E501

        :return: The layer_protocol_name of this TapiTopologyNode.
        :rtype: List[TapiCommonLayerProtocolName]
        """
        return self._layer_protocol_name

    @layer_protocol_name.setter
    def layer_protocol_name(self, layer_protocol_name: List[TapiCommonLayerProtocolName]):
        """Sets the layer_protocol_name of this TapiTopologyNode.

        none  # noqa: E501

        :param layer_protocol_name: The layer_protocol_name of this TapiTopologyNode.
        :type layer_protocol_name: List[TapiCommonLayerProtocolName]
        """

        self._layer_protocol_name = layer_protocol_name

    @property
    def encap_topology(self) -> TapiTopologyTopologyRef:
        """Gets the encap_topology of this TapiTopologyNode.


        :return: The encap_topology of this TapiTopologyNode.
        :rtype: TapiTopologyTopologyRef
        """
        return self._encap_topology

    @encap_topology.setter
    def encap_topology(self, encap_topology: TapiTopologyTopologyRef):
        """Sets the encap_topology of this TapiTopologyNode.


        :param encap_topology: The encap_topology of this TapiTopologyNode.
        :type encap_topology: TapiTopologyTopologyRef
        """

        self._encap_topology = encap_topology

    @property
    def owned_node_edge_point(self) -> List[TapiTopologyNodeEdgePoint]:
        """Gets the owned_node_edge_point of this TapiTopologyNode.

        none  # noqa: E501

        :return: The owned_node_edge_point of this TapiTopologyNode.
        :rtype: List[TapiTopologyNodeEdgePoint]
        """
        return self._owned_node_edge_point

    @owned_node_edge_point.setter
    def owned_node_edge_point(self, owned_node_edge_point: List[TapiTopologyNodeEdgePoint]):
        """Sets the owned_node_edge_point of this TapiTopologyNode.

        none  # noqa: E501

        :param owned_node_edge_point: The owned_node_edge_point of this TapiTopologyNode.
        :type owned_node_edge_point: List[TapiTopologyNodeEdgePoint]
        """

        self._owned_node_edge_point = owned_node_edge_point

    @property
    def node_rule_group(self) -> List[TapiTopologyNodeRuleGroup]:
        """Gets the node_rule_group of this TapiTopologyNode.

        none  # noqa: E501

        :return: The node_rule_group of this TapiTopologyNode.
        :rtype: List[TapiTopologyNodeRuleGroup]
        """
        return self._node_rule_group

    @node_rule_group.setter
    def node_rule_group(self, node_rule_group: List[TapiTopologyNodeRuleGroup]):
        """Sets the node_rule_group of this TapiTopologyNode.

        none  # noqa: E501

        :param node_rule_group: The node_rule_group of this TapiTopologyNode.
        :type node_rule_group: List[TapiTopologyNodeRuleGroup]
        """

        self._node_rule_group = node_rule_group

    @property
    def aggregated_node_edge_point(self) -> List[TapiTopologyNodeEdgePointRef]:
        """Gets the aggregated_node_edge_point of this TapiTopologyNode.

        none  # noqa: E501

        :return: The aggregated_node_edge_point of this TapiTopologyNode.
        :rtype: List[TapiTopologyNodeEdgePointRef]
        """
        return self._aggregated_node_edge_point

    @aggregated_node_edge_point.setter
    def aggregated_node_edge_point(self, aggregated_node_edge_point: List[TapiTopologyNodeEdgePointRef]):
        """Sets the aggregated_node_edge_point of this TapiTopologyNode.

        none  # noqa: E501

        :param aggregated_node_edge_point: The aggregated_node_edge_point of this TapiTopologyNode.
        :type aggregated_node_edge_point: List[TapiTopologyNodeEdgePointRef]
        """

        self._aggregated_node_edge_point = aggregated_node_edge_point
