/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project2.Row;
import net.sourceforge.plantuml.project2.TimeConverter;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class RowOverwrite
implements Row {
    private final Row r1;
    private final Row r2;

    public RowOverwrite(Row row, Row row2) {
        this.r1 = row;
        this.r2 = row2;
    }

    public TextBlock asTextBloc(final TimeConverter timeConverter) {
        return new TextBlock(){

            public void drawU(UGraphic uGraphic) {
                double d = RowOverwrite.this.getMinXwithoutHeader(timeConverter);
                double d2 = RowOverwrite.this.r1.getMinXwithoutHeader(timeConverter);
                double d3 = RowOverwrite.this.r2.getMinXwithoutHeader(timeConverter);
                RowOverwrite.this.r1.asTextBloc(timeConverter).drawU(uGraphic.apply(new UTranslate(d2 - d, 0.0)));
                RowOverwrite.this.r2.asTextBloc(timeConverter).drawU(uGraphic.apply(new UTranslate(d3 - d, 0.0)));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double d = RowOverwrite.this.getMaxXwithoutHeader(timeConverter) - RowOverwrite.this.getMinXwithoutHeader(timeConverter);
                double d2 = RowOverwrite.this.getHeight();
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public double getMinXwithoutHeader(TimeConverter timeConverter) {
        return Math.min(this.r1.getMinXwithoutHeader(timeConverter), this.r2.getMinXwithoutHeader(timeConverter));
    }

    public double getMaxXwithoutHeader(TimeConverter timeConverter) {
        return Math.max(this.r1.getMaxXwithoutHeader(timeConverter), this.r2.getMaxXwithoutHeader(timeConverter));
    }

    public double getHeight() {
        return Math.max(this.r1.getHeight(), this.r2.getHeight());
    }

    public TextBlock header() {
        return this.r1.header();
    }
}

