/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.PSystemBuilder;
import net.sourceforge.plantuml.api.HealthCheck;
import net.sourceforge.plantuml.api.INumberAnalyzed;
import net.sourceforge.plantuml.api.NumberAnalyzed;

public class Performance {
    private static final AtomicInteger maxThreadActiveCount = new AtomicInteger(0);
    private static final AtomicInteger diagramCount = new AtomicInteger(0);
    private static final AtomicInteger dotInterruption1 = new AtomicInteger(0);
    private static final AtomicInteger dotInterruption2 = new AtomicInteger(0);
    private static final AtomicInteger dotInterruption3 = new AtomicInteger(0);
    private static final NumberAnalyzed dotTime = new NumberAnalyzed();

    public static void updateDotTime2(long l) {
        dotTime.addValue((int)l);
    }

    public static void incDotInterruption1() {
        dotInterruption1.incrementAndGet();
    }

    public static void incDotInterruption2() {
        dotInterruption2.incrementAndGet();
    }

    public static void incDotInterruption3() {
        dotInterruption3.incrementAndGet();
    }

    public static void incDiagramCount() {
        int n;
        int n2;
        boolean bl;
        diagramCount.incrementAndGet();
        while (!(bl = (n2 = maxThreadActiveCount.get()) < (n = Thread.activeCount()) ? maxThreadActiveCount.compareAndSet(n2, n) : true)) {
        }
    }

    public static HealthCheck getHealthCheck() {
        long l;
        Object object;
        final long l2 = System.currentTimeMillis();
        long l3 = PSystemBuilder.startTime;
        final int n = Runtime.getRuntime().availableProcessors();
        final long l4 = Runtime.getRuntime().freeMemory();
        final long l5 = Runtime.getRuntime().maxMemory();
        final long l6 = Runtime.getRuntime().totalMemory();
        long l7 = l6 - l4;
        final int n2 = Thread.activeCount();
        int n3 = maxThreadActiveCount.get();
        int n4 = diagramCount.get();
        INumberAnalyzed iNumberAnalyzed = dotTime.getCopyImmutable();
        if (ManagementFactory.getOperatingSystemMXBean() instanceof OperatingSystemMXBean) {
            object = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            l = object.getProcessCpuTime() / 1000L / 1000L;
        } else {
            l = -1L;
        }
        object = ManagementFactory.getRuntimeMXBean().getName();
        int n5 = dotInterruption1.get();
        int n6 = dotInterruption2.get();
        int n7 = dotInterruption3.get();
        return new HealthCheck((String)object, l7, l3, n4, n5, n6, n7, n3, iNumberAnalyzed){
            final /* synthetic */ String val$pid;
            final /* synthetic */ long val$usedMemory;
            final /* synthetic */ long val$startTime;
            final /* synthetic */ int val$diagramCountValue;
            final /* synthetic */ int val$dotInterruption1Value;
            final /* synthetic */ int val$dotInterruption2Value;
            final /* synthetic */ int val$dotInterruption3Value;
            final /* synthetic */ int val$maxThreadActiveCountValue;
            final /* synthetic */ INumberAnalyzed val$dotCopy;
            {
                this.val$pid = string;
                this.val$usedMemory = l62;
                this.val$startTime = l7;
                this.val$diagramCountValue = n3;
                this.val$dotInterruption1Value = n4;
                this.val$dotInterruption2Value = n5;
                this.val$dotInterruption3Value = n6;
                this.val$maxThreadActiveCountValue = n7;
                this.val$dotCopy = iNumberAnalyzed;
            }

            public long totalMemory() {
                return l6;
            }

            public int threadActiveCount() {
                return n2;
            }

            public long maxMemory() {
                return l5;
            }

            public long freeMemory() {
                return l4;
            }

            public int availableProcessors() {
                return n;
            }

            public long jvmCpuTime() {
                return l;
            }

            public long timeStamp() {
                return l2;
            }

            public String pid() {
                return this.val$pid;
            }

            public long usedMemory() {
                return this.val$usedMemory;
            }

            public long runningTime() {
                return l2 - this.val$startTime;
            }

            public int diagramCount() {
                return this.val$diagramCountValue;
            }

            public int dotInterruption1() {
                return this.val$dotInterruption1Value;
            }

            public int dotInterruption2() {
                return this.val$dotInterruption2Value;
            }

            public int dotInterruption3() {
                return this.val$dotInterruption3Value;
            }

            public long startTime() {
                return this.val$startTime;
            }

            public int maxThreadActiveCount() {
                return this.val$maxThreadActiveCountValue;
            }

            public INumberAnalyzed dotTime() {
                return this.val$dotCopy;
            }
        };
    }

    public static void printHtml(HealthCheck healthCheck) throws IOException {
        PrintWriter printWriter = new PrintWriter("plantumlPerformance.html");
        printWriter.println("<html>");
        printWriter.println("<table border=1 cellpadding=4 cellspacing=0>");
        Performance.printHtmlTable(printWriter, healthCheck);
        printWriter.println("</table>");
        printWriter.println("</html>");
        printWriter.close();
    }

    public static void printHtmlTable(Writer writer, HealthCheck healthCheck) {
        PrintWriter printWriter = new PrintWriter(writer);
        Performance.printHtmlOut(printWriter, "PID", healthCheck.pid());
        Performance.printHtmlOut(printWriter, "AvailableProcessors", healthCheck.availableProcessors());
        Performance.printHtmlOut(printWriter, "Timestamp", new Date(healthCheck.timeStamp()));
        Performance.printHtmlOut(printWriter, "RunningTime", Performance.format(healthCheck.runningTime()));
        Performance.printHtmlOut(printWriter, "JvmCpuTime", Performance.format(healthCheck.jvmCpuTime()));
        Performance.printHtmlOut(printWriter, "TotalDotTime", Performance.format(healthCheck.dotTime().getSum()));
        Performance.printHtmlOut(printWriter, "ThreadActiveCount", healthCheck.threadActiveCount());
        Performance.printHtmlOut(printWriter, "MaxMemory", Performance.format(healthCheck.maxMemory()));
        Performance.printHtmlOut(printWriter, "TotalMemory", Performance.format(healthCheck.totalMemory()));
        Performance.printHtmlOut(printWriter, "UsedMemory", Performance.format(healthCheck.usedMemory()));
        Performance.printHtmlOut(printWriter, "FreeMemory", Performance.format(healthCheck.freeMemory()));
        Performance.printHtmlOut(printWriter, "DiagramCount", healthCheck.diagramCount());
        Performance.printHtmlOut(printWriter, "DotCount", healthCheck.dotTime().getNb());
        Performance.printHtmlOut(printWriter, "DotInterruption1", healthCheck.dotInterruption1());
        Performance.printHtmlOut(printWriter, "DotInterruption2", healthCheck.dotInterruption2());
        Performance.printHtmlOut(printWriter, "DotInterruption3", healthCheck.dotInterruption3());
        printWriter.flush();
    }

    public static String format(long l) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setGroupingSize(3);
        decimalFormat.setMaximumFractionDigits(0);
        String string = decimalFormat.format(l).replace(',', ' ');
        return string;
    }

    public static void printHtmlOut(PrintWriter printWriter, String string, Object object) {
        printWriter.println("<tr>");
        printWriter.println("<td><b>" + string + "</b></td>");
        printWriter.println("<td align=right>" + object + "</td>");
        printWriter.println("</tr>");
        printWriter.println("<tr>");
    }
}

