from enum import Enum
from common.DeviceTypes import DeviceTypeEnum
from device.service.database.DeviceModel import ORM_DeviceDriverEnum

class FilterFieldEnum(Enum):
    DEVICE_TYPE   = 'device_type'
    DRIVER        = 'driver'
    VENDOR        = 'vendor'
    MODEL         = 'model'
    SERIAL_NUMBER = 'serial_number'

# Map allowed filter fields to allowed values per Filter field. If no restriction (free text) None is specified
FILTER_FIELD_ALLOWED_VALUES = {
    FilterFieldEnum.DEVICE_TYPE.value   : {i.value for i in DeviceTypeEnum},
    FilterFieldEnum.DRIVER.value        : {i.value for i in ORM_DeviceDriverEnum},
    FilterFieldEnum.VENDOR.value        : None,
    FilterFieldEnum.MODEL.value         : None,
    FilterFieldEnum.SERIAL_NUMBER.value : None,
}
