from flask_httpauth import HTTPBasicAuth
from werkzeug.security import check_password_hash
from compute.Config import RESTAPI_USERS

HTTP_AUTH = HTTPBasicAuth()

@HTTP_AUTH.verify_password
def verify_password(username, password):
    if username not in RESTAPI_USERS: return None
    if not check_password_hash(RESTAPI_USERS[username], password): return None
    return username
