from __future__ import annotations
from typing import Optional, Union
from common.type_checkers.Checkers import chk_integer
from .Field import Field

class IntegerField(Field):
    def __init__(
        self, *args, min_value : Optional[int] = None, max_value : Optional[int] = None, **kwargs) -> None:

        super().__init__(*args, type_=int, **kwargs)
        self._min_value = None if min_value is None else \
            chk_integer('IntegerField.min_value', min_value)
        self._max_value = None if max_value is None else \
            chk_integer('IntegerField.max_value', max_value, min_value=self._min_value)

    def validate(self, value : Union[int, str], try_convert_type=False) -> int:
        value = super().validate(value)
        if value is None: return None
        if try_convert_type and isinstance(value, str): value = int(value)
        return chk_integer(self.name, value, min_value=self._min_value, max_value=self._max_value)
