package eu.teraflow.automation.device;

import device.DeviceService;
import eu.teraflow.automation.Serializer;
import eu.teraflow.automation.device.model.Device;
import eu.teraflow.automation.device.model.DeviceConfig;
import io.quarkus.grpc.GrpcClient;
import io.smallrye.mutiny.Uni;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DeviceGatewayImpl implements DeviceGateway {
    private static final Logger LOGGER = Logger.getLogger(DeviceGatewayImpl.class);

    @GrpcClient("device")
    DeviceService deviceDelegate;

    private final Serializer serializer;

    @Inject
    public DeviceGatewayImpl(Serializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public Uni<DeviceConfig> getInitialConfiguration(String deviceId) {
        final var serializedDeviceId = serializer.serializeDeviceId(deviceId);

        return deviceDelegate
                .getInitialConfig(serializedDeviceId)
                .onItem()
                .transform(serializer::deserialize);
    }

    @Override
    public Uni<String> configureDevice(Device device) {
        final var serializedDevice = serializer.serialize(device);

        return deviceDelegate
                .configureDevice(serializedDevice)
                .onItem()
                .transform(serializer::deserialize);
    }
}
