# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class otn(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/te-link-attributes/interface-switching-capability/max-lsp-bandwidth/te-bandwidth/otn. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Maximum bandwidth attributes for OTN paths.
  """
  __slots__ = ('_path_helper', '_extmethods', '__odu_type','__max_ts_number',)

  _yang_name = 'otn'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__odu_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="odu-type", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    self.__max_ts_number = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="max-ts-number", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'te-link-attributes', 'interface-switching-capability', 'max-lsp-bandwidth', 'te-bandwidth', 'otn']

  def _get_odu_type(self):
    """
    Getter method for odu_type, mapped from YANG variable /networks/network/link/te/te_link_attributes/interface_switching_capability/max_lsp_bandwidth/te_bandwidth/otn/odu_type (identityref)

    YANG Description: ODU type
    """
    return self.__odu_type
      
  def _set_odu_type(self, v, load=False):
    """
    Setter method for odu_type, mapped from YANG variable /networks/network/link/te/te_link_attributes/interface_switching_capability/max_lsp_bandwidth/te_bandwidth/otn/odu_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_odu_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_odu_type() directly.

    YANG Description: ODU type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="odu-type", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """odu_type must be of a type compatible with identityref""",
          'defined-type': "ietf-otn-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="odu-type", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)""",
        })

    self.__odu_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_odu_type(self):
    self.__odu_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU0': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU1': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU2e': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU3': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODU4': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:ODUflex-resizable': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="odu-type", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)


  def _get_max_ts_number(self):
    """
    Getter method for max_ts_number, mapped from YANG variable /networks/network/link/te/te_link_attributes/interface_switching_capability/max_lsp_bandwidth/te_bandwidth/otn/max_ts_number (uint16)

    YANG Description: The maximum number of Tributary Slots (TS) that could be
used  by an ODUflex LSP.
    """
    return self.__max_ts_number
      
  def _set_max_ts_number(self, v, load=False):
    """
    Setter method for max_ts_number, mapped from YANG variable /networks/network/link/te/te_link_attributes/interface_switching_capability/max_lsp_bandwidth/te_bandwidth/otn/max_ts_number (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ts_number is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_ts_number() directly.

    YANG Description: The maximum number of Tributary Slots (TS) that could be
used  by an ODUflex LSP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="max-ts-number", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ts_number must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="max-ts-number", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint16', is_config=True)""",
        })

    self.__max_ts_number = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_ts_number(self):
    self.__max_ts_number = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="max-ts-number", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='uint16', is_config=True)

  odu_type = __builtin__.property(_get_odu_type, _set_odu_type)
  max_ts_number = __builtin__.property(_get_max_ts_number, _set_max_ts_number)

  __choices__ = {'technology': {'otn': ['odu_type', 'max_ts_number']}}
  _pyangbind_elements = OrderedDict([('odu_type', odu_type), ('max_ts_number', max_ts_number), ])


