import logging, sys
from common.proto.context_pb2 import ServiceId
from common.tools.object_factory.Context import json_context_id
from common.tools.object_factory.Service import json_service_id
from context.client.ContextClient import ContextClient
from service.service.task_scheduler.TaskScheduler import TasksScheduler

logging.basicConfig(level=logging.INFO, format="[%(asctime)s] %(levelname)s:%(name)s:%(message)s")

def main():
    context_uuid = 'admin'
    service_uuid = 'main' #'f0cbafdb-8fad-41da-b622-d9ddf5ce243d'
    service_id = ServiceId(**json_service_id(service_uuid, context_id=json_context_id(context_uuid)))

    context_client = ContextClient()
    service = context_client.GetService(service_id)

    ts = TasksScheduler(None)
    ts.compose_from_service(service, is_delete=True)
    ts.execute_all(dry_run=True)

    return 0

if __name__ == '__main__':
    sys.exit(main())
