from typing import Dict

class _Entity:
    def __init__(self, entity_uuid, parent=None):
        if (parent is None) or (not isinstance(parent, _Entity)):
            raise AttributeError('parent must be an instance of _Entity')
        self._entity_uuid = entity_uuid
        self._parent = parent
        self._context = self._parent.get_context()

    def get_uuid(self): return(self._entity_uuid)
    def get_parent(self): return(self._parent)
    def get_context(self): return(self._context)

    def load(self):
        raise NotImplementedError()

    def create(self):
        raise NotImplementedError()

    def delete(self):
        raise NotImplementedError()

    def dump(self) -> Dict:
        raise NotImplementedError()
