import json, logging, sys, time
from redis.client import Redis
from .tools.RedisTools import dump_keys
from .Context import Context
from .OperationalStatus import OperationalStatus

logging.basicConfig(level=logging.INFO)
LOGGER = logging.getLogger(__name__)

def main():
    redis_client = Redis('127.0.0.1', 31926)

    LOGGER.info('Cleaning up...')
    LOGGER.info('  keys before = {}'.format(str(redis_client.keys())))
    keys = redis_client.keys()
    for key in keys:
        key_name = key.decode('UTF-8')
        if(key_name == 'topology'): continue
        redis_client.delete(key_name)
    LOGGER.info('  keys after  = {}'.format(str(redis_client.keys())))

    with Context('ctx-test', redis_client) as context:
        topology = context.topology('base-topo').create()

        device_1 = topology.device('dev1').create(type='ROADM', config='<config/>', operational_status=OperationalStatus.ENABLED)
        endpoint_dev1_to_dev2 = device_1.endpoint('to-dev2').create(type='WDM')
        endpoint_dev1_to_dev3 = device_1.endpoint('to-dev3').create(type='WDM')
        endpoint_dev1_to_dev4 = device_1.endpoint('to-dev4').create(type='WDM')

        device_2 = topology.device('dev2').create(type='ROADM', config='<config/>', operational_status=OperationalStatus.ENABLED)
        endpoint_dev2_to_dev1 = device_2.endpoint('to-dev1').create(type='WDM')
        endpoint_dev2_to_dev3 = device_2.endpoint('to-dev3').create(type='WDM')
        endpoint_dev2_to_dev4 = device_2.endpoint('to-dev4').create(type='WDM')

        device_3 = topology.device('dev3').create(type='ROADM', config='<config/>', operational_status=OperationalStatus.ENABLED)
        endpoint_dev3_to_dev1 = device_3.endpoint('to-dev1').create(type='WDM')
        endpoint_dev3_to_dev2 = device_3.endpoint('to-dev2').create(type='WDM')
        endpoint_dev3_to_dev4 = device_3.endpoint('to-dev4').create(type='WDM')

        device_4 = topology.device('dev4').create(type='ROADM', config='<config/>', operational_status=OperationalStatus.ENABLED)
        endpoint_dev4_to_dev1 = device_4.endpoint('to-dev1').create(type='WDM')
        endpoint_dev4_to_dev2 = device_4.endpoint('to-dev2').create(type='WDM')
        endpoint_dev4_to_dev3 = device_4.endpoint('to-dev3').create(type='WDM')

        link_dev1_to_dev2 = topology.link('dev1/to-dev2 ==> dev2/to-dev1').create()
        link_dev1_to_dev2.endpoint('dev1/to-dev2').create(endpoint_dev1_to_dev2)
        link_dev1_to_dev2.endpoint('dev2/to-dev1').create(endpoint_dev2_to_dev1)

        link_dev1_to_dev3 = topology.link('dev1/to-dev3 ==> dev3/to-dev1').create()
        link_dev1_to_dev3.endpoint('dev1/to-dev3').create(endpoint_dev1_to_dev3)
        link_dev1_to_dev3.endpoint('dev3/to-dev1').create(endpoint_dev3_to_dev1)

        link_dev1_to_dev4 = topology.link('dev1/to-dev4 ==> dev4/to-dev1').create()
        link_dev1_to_dev4.endpoint('dev1/to-dev4').create(endpoint_dev1_to_dev4)
        link_dev1_to_dev4.endpoint('dev4/to-dev1').create(endpoint_dev4_to_dev1)

        link_dev2_to_dev1 = topology.link('dev2/to-dev1 ==> dev1/to-dev2').create()
        link_dev2_to_dev1.endpoint('dev2/to-dev1').create(endpoint_dev2_to_dev1)
        link_dev2_to_dev1.endpoint('dev1/to-dev2').create(endpoint_dev1_to_dev2)

        link_dev2_to_dev3 = topology.link('dev2/to-dev3 ==> dev3/to-dev2').create()
        link_dev2_to_dev3.endpoint('dev2/to-dev3').create(endpoint_dev2_to_dev3)
        link_dev2_to_dev3.endpoint('dev3/to-dev2').create(endpoint_dev3_to_dev2)

        link_dev2_to_dev4 = topology.link('dev2/to-dev4 ==> dev4/to-dev2').create()
        link_dev2_to_dev4.endpoint('dev2/to-dev4').create(endpoint_dev2_to_dev4)
        link_dev2_to_dev4.endpoint('dev4/to-dev2').create(endpoint_dev4_to_dev2)

        link_dev3_to_dev1 = topology.link('dev3/to-dev1 ==> dev1/to-dev3').create()
        link_dev3_to_dev1.endpoint('dev3/to-dev1').create(endpoint_dev3_to_dev1)
        link_dev3_to_dev1.endpoint('dev1/to-dev3').create(endpoint_dev1_to_dev3)

        link_dev3_to_dev2 = topology.link('dev3/to-dev2 ==> dev2/to-dev3').create()
        link_dev3_to_dev2.endpoint('dev3/to-dev2').create(endpoint_dev3_to_dev2)
        link_dev3_to_dev2.endpoint('dev2/to-dev3').create(endpoint_dev2_to_dev3)

        link_dev3_to_dev4 = topology.link('dev3/to-dev4 ==> dev4/to-dev3').create()
        link_dev3_to_dev4.endpoint('dev3/to-dev4').create(endpoint_dev3_to_dev4)
        link_dev3_to_dev4.endpoint('dev4/to-dev3').create(endpoint_dev4_to_dev3)

        link_dev4_to_dev1 = topology.link('dev4/to-dev1 ==> dev1/to-dev4').create()
        link_dev4_to_dev1.endpoint('dev4/to-dev1').create(endpoint_dev4_to_dev1)
        link_dev4_to_dev1.endpoint('dev1/to-dev4').create(endpoint_dev1_to_dev4)

        link_dev4_to_dev2 = topology.link('dev4/to-dev2 ==> dev2/to-dev4').create()
        link_dev4_to_dev2.endpoint('dev4/to-dev2').create(endpoint_dev4_to_dev2)
        link_dev4_to_dev2.endpoint('dev2/to-dev4').create(endpoint_dev2_to_dev4)

        link_dev4_to_dev3 = topology.link('dev4/to-dev3 ==> dev3/to-dev4').create()
        link_dev4_to_dev3.endpoint('dev4/to-dev3').create(endpoint_dev4_to_dev3)
        link_dev4_to_dev3.endpoint('dev3/to-dev4').create(endpoint_dev3_to_dev4)

        dump_keys(redis_client, LOGGER)

    with Context('ctx-test', redis_client) as context:
        t0 = time.time()
        json_topology = context.topology('base-topo').dump()
        t1 = time.time()
        LOGGER.info(json.dumps(json_topology))
        LOGGER.info('Dump from Redis elapsed: {}'.format(1000.0 * (t1-t0)))

    return(0)

if __name__=='__main__':
    sys.exit(main())
