from typing import Dict
from .tools._Entity import _Entity
from .tools.EntityAttributes import EntityAttributes
from .Endpoint import Endpoint
from .Keys import KEY_LINK_ENDPOINT

VALIDATORS = {
    'device_uuid': lambda v: v is None or isinstance(v, str),
    'endpoint_uuid': lambda v: v is None or isinstance(v, str),
}

class LinkEndpoint(_Entity):
    def __init__(self, link_endpoint_uuid : str, parent : 'Link'): # type: ignore
        super().__init__(link_endpoint_uuid, parent=parent)
        self.link_endpoint_uuid = self.get_uuid()
        self.link_uuid = self._parent.get_uuid()
        self.topology_uuid = self._parent._parent.get_uuid()
        self.context_uuid = self._parent._parent._parent.get_uuid()
        self.attributes = EntityAttributes(self, KEY_LINK_ENDPOINT, VALIDATORS)

    def create(self, endpoint : Endpoint) -> 'LinkEndpoint':
        self.update(update_attributes={
            'device_uuid': endpoint._parent.get_uuid(),
            'endpoint_uuid': endpoint.get_uuid(),
        })
        self._parent.endpoints.add(self.get_uuid())
        return self

    def update(self, update_attributes={}, remove_attributes=[]) -> 'LinkEndpoint':
        self.attributes.update(update_attributes=update_attributes, remove_attributes=remove_attributes)
        return self

    def delete(self) -> None:
        remove_attributes = ['device_uuid', 'endpoint_uuid']
        self.update(remove_attributes=remove_attributes)
        self._parent.endpoints.delete(self.get_uuid())

    def dump(self) -> Dict:
        attributes = self.attributes.get()
        return {
            'topoId': {'uuid': self.topology_uuid},
            'dev_id': {'uuid': attributes.get('device_uuid', None)},
            'port_id': {'uuid': attributes.get('endpoint_uuid', None)},
        }
