from typing import Dict
from .tools._Entity import _Entity
from .tools.EntityCollection import EntityCollection
from .Keys import KEY_LINK_ENDPOINTS
from .LinkEndpoint import LinkEndpoint

class Link(_Entity):
    def __init__(self, link_uuid : str, parent : 'Topology'): # type: ignore
        super().__init__(link_uuid, parent=parent)
        self.link_uuid = self.get_uuid()
        self.topology_uuid = self._parent.get_uuid()
        self.context_uuid = self._parent._parent.get_uuid()
        self.endpoints = EntityCollection(self, KEY_LINK_ENDPOINTS)

    def endpoint(self, link_endpoint_uuid : str) -> LinkEndpoint:
        return LinkEndpoint(link_endpoint_uuid, self)

    def create(self) -> 'Link':
        self._parent.links.add(self.get_uuid())
        return self

    def delete(self) -> None:
        self._parent.links.delete(self.get_uuid())

    def dump(self) -> Dict:
        endpoints = [self.endpoint(link_endpoint_uuid).dump() for link_endpoint_uuid in self.endpoints.get()]
        return {
            'link_id': {'link_id': {'uuid': self.link_uuid}},
            'endpointList': endpoints
        }
