from typing import Dict
from .tools._Entity import _Entity
from .tools.EntityAttributes import EntityAttributes
from .Keys import KEY_ENDPOINT

VALIDATORS = {
    'port_type': lambda v: v is None or isinstance(v, str),
}

class Endpoint(_Entity):
    def __init__(self, endpoint_uuid : str, parent : 'Device'): # type: ignore
        super().__init__(endpoint_uuid, parent=parent)
        self.endpoint_uuid = self.get_uuid()
        self.device_uuid = self._parent.get_uuid()
        self.topology_uuid = self._parent._parent.get_uuid()
        self.context_uuid = self._parent._parent._parent.get_uuid()
        self.attributes = EntityAttributes(self, KEY_ENDPOINT, VALIDATORS)

    def create(self, type : str) -> 'Endpoint':
        self.update(update_attributes={
            'port_type': type
        })
        self._parent.endpoints.add(self.get_uuid())
        return self

    def update(self, update_attributes={}, remove_attributes=[]) -> 'Endpoint':
        self.attributes.update(update_attributes=update_attributes, remove_attributes=remove_attributes)
        return self

    def delete(self) -> None:
        remove_attributes = ['port_type']
        self.update(remove_attributes=remove_attributes)
        self._parent.endpoints.delete(self.get_uuid())

    def dump_uuid(self) -> Dict:
        return {
            'topoId': {'uuid': self.topology_uuid},
            'dev_id': {'uuid': self.device_uuid},
            'port_id': {'uuid': self.endpoint_uuid},
        }

    def dump(self) -> Dict:
        attributes = self.attributes.get()
        return {
            'port_id': self.dump_uuid(),
            'port_type': attributes.get('port_type', None),
        }
