def dump_keys(redis_client, logger):
    logger.info('Dump keys...')
    keys = redis_client.keys()
    logger.info('  keys = {}'.format(str(keys)))
    for key_name in keys:
        key_name = key_name.decode('UTF-8')
        if not key_name.startswith('context'): continue
        key_type = redis_client.type(key_name)
        if key_type is not None: key_type = key_type.decode('UTF-8')
        key_content = {
            'hash'  : lambda key: {k.decode('UTF-8'):v.decode('UTF-8') for k,v in redis_client.hgetall(key).items()},
            'list'  : lambda key: [m.decode('UTF-8') for m in redis_client.lrange(key, 0, -1)],
            'set'   : lambda key: {m.decode('UTF-8') for m in redis_client.smembers(key)},
            'string': lambda key: redis_client.get(key).decode('UTF-8'),
        }.get(key_type, lambda key: 'UNSUPPORTED_TYPE')
        logger.info('  key {} {}: {}'.format(key_type, key_name, key_content(key_name)))
