from typing import Dict
from .tools._Entity import _Entity
from .tools.EntityAttributes import EntityAttributes
from .tools.EntityCollection import EntityCollection
from .Keys import KEY_TOPOLOGY, KEY_DEVICES, KEY_LINKS
from .Device import Device
from .Link import Link

VALIDATORS = {}

class Topology(_Entity):
    def __init__(self, topology_uuid : str, parent : 'Context'): # type: ignore
        super().__init__(topology_uuid, parent=parent)
        self.topology_uuid = self.get_uuid()
        self.context_uuid = self._parent.get_uuid()
        self.attributes = EntityAttributes(self, KEY_TOPOLOGY, validators=VALIDATORS)
        self.devices = EntityCollection(self, KEY_DEVICES)
        self.links = EntityCollection(self, KEY_LINKS)

    def device(self, device_uuid : str) -> Device:
        return Device(device_uuid, self)

    def link(self, link_uuid : str) -> Link:
        return Link(link_uuid, self)

    def create(self) -> 'Topology':
        self._parent.topologies.add(self.get_uuid())
        return self

    def delete(self):
        self._parent.topologies.delete(self.get_uuid())

    def dump(self) -> Dict:
        devices = [self.device(device_uuid).dump() for device_uuid in self.devices.get()]
        links   = [self.link  (link_uuid  ).dump() for link_uuid   in self.links.get()]
        return {
            'topoId': {
                'contextId': {'contextUuid': {'uuid': self.context_uuid}},
                'topoId': {'uuid': self.topology_uuid},
            },
            'device': devices,
            'link': links,
        }
